import org.apache.commons.io.FileUtils
@Grab('org.eclipse.jgit:org.eclipse.jgit:5.4.2.201908231537-r')
import org.eclipse.jgit.api.Git

import java.nio.file.Files
import java.nio.file.Path
import java.nio.file.Paths

Properties requestProperties = request.properties
String githubRepoPrefix = "https://github.com/browserstack/"
String repoName = "testng-browserstack"
String repoBranch = null
String repoFolder = null
if (requestProperties.getProperty("BROWSERSTACK_PROJECT_REPO") != null && !requestProperties.getProperty("BROWSERSTACK_PROJECT_REPO").toString().equals("BROWSERSTACK_PROJECT_REPO")) {
    String repoProperty = requestProperties.getProperty("BROWSERSTACK_PROJECT_REPO").toString()
    int colonIndex  = repoProperty.indexOf(":")
    int slashIndex = repoProperty.indexOf("/")
    if (colonIndex != -1 && slashIndex != -1){
        repoName = repoProperty.substring(0, slashIndex)
        repoFolder = repoProperty.substring(slashIndex+1, colonIndex)
        repoBranch = repoProperty.substring(colonIndex+1)
    } else if (colonIndex != -1) {
        repoName = repoProperty.substring(0, colonIndex)
        repoBranch = repoProperty.substring(colonIndex+1)
    } else if (slashIndex != -1) {
        repoName = repoProperty.substring(0, slashIndex)
        repoFolder = repoProperty.substring(slashIndex+1)
    } else {
        repoName = repoProperty
    }
}

String archetypeDirectory = request.outputDirectory + File.separator + request.artifactId
FileUtils.cleanDirectory(new File(archetypeDirectory))
String repoUrl = githubRepoPrefix + repoName + ".git"
Git.cloneRepository()
        .setURI(repoUrl)
        .setBranch(repoBranch)
        .setDirectory(new File(archetypeDirectory))
        .call()
        .close()
try {
    if (repoFolder != null) {
        Path tempDirectory = Files.createTempDirectory("browserStackArchetype");
        tempDirectory.toFile().deleteOnExit()
        FileUtils.copyDirectory(new File(archetypeDirectory), tempDirectory.toFile())
        FileUtils.cleanDirectory(new File(archetypeDirectory))
        FileUtils.copyDirectory(new File((tempDirectory.toFile().getPath() + File.separator + repoFolder)), new File(archetypeDirectory))
        FileUtils.deleteDirectory(tempDirectory.toFile())
    }

    new File(archetypeDirectory).traverse(type: groovy.io.FileType.FILES, nameFilter: ~/browserstack.yml/) { ymlFile ->
        Path ymlFileOutput = Paths.get(ymlFile.getAbsolutePath())
        def browserstackYmlContent = new StringBuilder()
        Scanner scGenerated = new Scanner(ymlFileOutput)
        while (scGenerated.hasNext()) {
            currentLine = scGenerated.nextLine()
            if (currentLine.contains("userName:") && requestProperties.getProperty("BROWSERSTACK_USERNAME") != null) {
                currentLine = !requestProperties.getProperty("BROWSERSTACK_USERNAME").toString().equals("YOUR_USERNAME") ? "userName: " + requestProperties.getProperty("BROWSERSTACK_USERNAME").toString() : currentLine
            } else if (currentLine.contains("accessKey:") && requestProperties.getProperty("BROWSERSTACK_ACCESS_KEY") != null) {
                currentLine = !requestProperties.getProperty("BROWSERSTACK_ACCESS_KEY").toString().equals("YOUR_ACCESS_KEY") ? "accessKey: " + requestProperties.getProperty("BROWSERSTACK_ACCESS_KEY").toString() : currentLine
            } else if (currentLine.contains("app:") && requestProperties.getProperty("BROWSERSTACK_APP") != null) {
                currentLine = !requestProperties.getProperty("BROWSERSTACK_APP").toString().equals("BROWSERSTACK_APP") ? "app: " + requestProperties.getProperty("BROWSERSTACK_APP").toString() : currentLine
            } else if (currentLine.contains("source:")) {
                currentLine = "source: " + repoName + ":archetype-setup:v1.0"
            }
            browserstackYmlContent.append(currentLine).append("\n")
        }
        PrintWriter writer = new PrintWriter(ymlFileOutput.toFile())
        writer.write(browserstackYmlContent.toString())
        writer.close()
    }
} catch (Throwable e) {
    e.printStackTrace()
}
