/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.vpc.model;

import com.byteplus.vpc.model.TagForCreateBandwidthPackageInput;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class CreateBandwidthPackageRequest {
    @SerializedName(value="Bandwidth")
    private Integer bandwidth = null;
    @SerializedName(value="BandwidthPackageName")
    private String bandwidthPackageName = null;
    @SerializedName(value="BillingType")
    private Integer billingType = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="ISP")
    private ISPEnum ISP = null;
    @SerializedName(value="Period")
    private Integer period = null;
    @SerializedName(value="PeriodUnit")
    private Integer periodUnit = null;
    @SerializedName(value="ProjectName")
    private String projectName = null;
    @SerializedName(value="Protocol")
    private ProtocolEnum protocol = null;
    @SerializedName(value="SecurityProtectionTypes")
    private List<String> securityProtectionTypes = null;
    @SerializedName(value="Tags")
    private List<TagForCreateBandwidthPackageInput> tags = null;

    public CreateBandwidthPackageRequest bandwidth(Integer bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    @NotNull
    @Min(value=2L)
    @Schema(required=true, description="")
    public Integer getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(Integer bandwidth) {
        this.bandwidth = bandwidth;
    }

    public CreateBandwidthPackageRequest bandwidthPackageName(String bandwidthPackageName) {
        this.bandwidthPackageName = bandwidthPackageName;
        return this;
    }

    @Size(min=1, max=128)
    @Schema(description="")
    public String getBandwidthPackageName() {
        return this.bandwidthPackageName;
    }

    public void setBandwidthPackageName(String bandwidthPackageName) {
        this.bandwidthPackageName = bandwidthPackageName;
    }

    public CreateBandwidthPackageRequest billingType(Integer billingType) {
        this.billingType = billingType;
        return this;
    }

    @Min(value=1L)
    @Max(value=4L)
    @Schema(description="")
    public Integer getBillingType() {
        return this.billingType;
    }

    public void setBillingType(Integer billingType) {
        this.billingType = billingType;
    }

    public CreateBandwidthPackageRequest description(String description) {
        this.description = description;
        return this;
    }

    @Size(min=1, max=255)
    @Schema(description="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateBandwidthPackageRequest ISP(ISPEnum ISP) {
        this.ISP = ISP;
        return this;
    }

    @Schema(description="")
    public ISPEnum getISP() {
        return this.ISP;
    }

    public void setISP(ISPEnum ISP) {
        this.ISP = ISP;
    }

    public CreateBandwidthPackageRequest period(Integer period) {
        this.period = period;
        return this;
    }

    @Schema(description="")
    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public CreateBandwidthPackageRequest periodUnit(Integer periodUnit) {
        this.periodUnit = periodUnit;
        return this;
    }

    @Min(value=1L)
    @Max(value=2L)
    @Schema(description="")
    public Integer getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(Integer periodUnit) {
        this.periodUnit = periodUnit;
    }

    public CreateBandwidthPackageRequest projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @Schema(description="")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public CreateBandwidthPackageRequest protocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    @Schema(description="")
    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public CreateBandwidthPackageRequest securityProtectionTypes(List<String> securityProtectionTypes) {
        this.securityProtectionTypes = securityProtectionTypes;
        return this;
    }

    public CreateBandwidthPackageRequest addSecurityProtectionTypesItem(String securityProtectionTypesItem) {
        if (this.securityProtectionTypes == null) {
            this.securityProtectionTypes = new ArrayList<String>();
        }
        this.securityProtectionTypes.add(securityProtectionTypesItem);
        return this;
    }

    @Schema(description="")
    public List<String> getSecurityProtectionTypes() {
        return this.securityProtectionTypes;
    }

    public void setSecurityProtectionTypes(List<String> securityProtectionTypes) {
        this.securityProtectionTypes = securityProtectionTypes;
    }

    public CreateBandwidthPackageRequest tags(List<TagForCreateBandwidthPackageInput> tags) {
        this.tags = tags;
        return this;
    }

    public CreateBandwidthPackageRequest addTagsItem(TagForCreateBandwidthPackageInput tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagForCreateBandwidthPackageInput>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagForCreateBandwidthPackageInput> getTags() {
        return this.tags;
    }

    public void setTags(List<TagForCreateBandwidthPackageInput> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBandwidthPackageRequest createBandwidthPackageRequest = (CreateBandwidthPackageRequest)o;
        return Objects.equals(this.bandwidth, createBandwidthPackageRequest.bandwidth) && Objects.equals(this.bandwidthPackageName, createBandwidthPackageRequest.bandwidthPackageName) && Objects.equals(this.billingType, createBandwidthPackageRequest.billingType) && Objects.equals(this.description, createBandwidthPackageRequest.description) && Objects.equals((Object)this.ISP, (Object)createBandwidthPackageRequest.ISP) && Objects.equals(this.period, createBandwidthPackageRequest.period) && Objects.equals(this.periodUnit, createBandwidthPackageRequest.periodUnit) && Objects.equals(this.projectName, createBandwidthPackageRequest.projectName) && Objects.equals((Object)this.protocol, (Object)createBandwidthPackageRequest.protocol) && Objects.equals(this.securityProtectionTypes, createBandwidthPackageRequest.securityProtectionTypes) && Objects.equals(this.tags, createBandwidthPackageRequest.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bandwidth, this.bandwidthPackageName, this.billingType, this.description, this.ISP, this.period, this.periodUnit, this.projectName, this.protocol, this.securityProtectionTypes, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateBandwidthPackageRequest {\n");
        sb.append("    bandwidth: ").append(this.toIndentedString(this.bandwidth)).append("\n");
        sb.append("    bandwidthPackageName: ").append(this.toIndentedString(this.bandwidthPackageName)).append("\n");
        sb.append("    billingType: ").append(this.toIndentedString(this.billingType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    ISP: ").append(this.toIndentedString((Object)this.ISP)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    periodUnit: ").append(this.toIndentedString(this.periodUnit)).append("\n");
        sb.append("    projectName: ").append(this.toIndentedString(this.projectName)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    securityProtectionTypes: ").append(this.toIndentedString(this.securityProtectionTypes)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProtocolEnum {
        IPV4("IPv4"),
        DUAL_STACK("Dual-stack"),
        IPV6("IPv6");

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProtocolEnum fromValue(String input) {
            for (ProtocolEnum b : ProtocolEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProtocolEnum> {
            public void write(JsonWriter jsonWriter, ProtocolEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ProtocolEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProtocolEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ISPEnum {
        BGP("BGP"),
        SINGLELINE_BGP("SingleLine_BGP"),
        STATIC_BGP("Static_BGP"),
        FUSION_BGP("Fusion_BGP"),
        CHINAMOBILE("ChinaMobile"),
        CHINAUNICOM("ChinaUnicom"),
        CHINATELECOM("ChinaTelecom"),
        CHINAMOBILE_VALUE("ChinaMobile_Value"),
        CHINAUNICOM_VALUE("ChinaUnicom_Value"),
        CHINATELECOM_VALUE("ChinaTelecom_Value");

        private String value;

        private ISPEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ISPEnum fromValue(String input) {
            for (ISPEnum b : ISPEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ISPEnum> {
            public void write(JsonWriter jsonWriter, ISPEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ISPEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ISPEnum.fromValue(value);
            }
        }
    }
}

