/*
 * Decompiled with CFR 0.152.
 */
package com.clivern.wit;

import com.clivern.wit.api.Contract;
import com.clivern.wit.exception.DataNotFound;
import com.clivern.wit.exception.DataNotValid;
import com.clivern.wit.util.Config;
import com.clivern.wit.util.Http;
import java.io.IOException;
import java.util.HashMap;
import org.pmw.tinylog.Logger;

public class Wit {
    protected Config config;
    protected String response = "";
    protected Boolean status = false;
    protected String error = "";

    public Wit(Config config) {
        this.config = config;
    }

    public Boolean send(Contract item) throws DataNotValid, DataNotFound, IOException {
        this.status = false;
        this.response = "";
        this.error = "";
        try {
            item.setAppId(this.config.get("wit_api_id", ""));
            item.setAccessToken(this.config.get("wit_access_token", ""));
            item.config();
            HashMap headers = (HashMap)item.getHeaders();
            Logger.info((String)item.debug());
            Http httpRequest = new Http(item.getUrl(), item.getMethod(), item.getHeaders(), item.getData());
            this.response = httpRequest.execute();
        }
        catch (Exception e) {
            this.status = false;
            this.error = "Error! " + e.getMessage();
            Logger.error((String)this.error);
            return this.status;
        }
        this.status = this.response.equals("") || this.response.indexOf("error") > 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        return this.status;
    }

    public String getResponse() {
        return this.response;
    }

    public String getError() {
        return this.error;
    }

    public Boolean getRequestStatus() {
        return this.status;
    }

    public String getName() {
        return "Wit-Java ~ v1.0.0";
    }
}

