/*
 * Decompiled with CFR 0.152.
 */
package com.clivern.wit.api;

import com.clivern.wit.api.Contract;
import com.clivern.wit.api.endpoint.EntityEndpoint;
import com.clivern.wit.exception.DataNotFound;
import com.clivern.wit.exception.DataNotValid;
import java.util.HashMap;
import java.util.Map;
import org.pmw.tinylog.Logger;

public class Entity
implements Contract {
    public String appId = "";
    public String accessToken = "";
    public String endpointName = "";
    public String contentType = EntityEndpoint.CONTENT_TYPE;
    public String url = "";
    public String method = "";
    public Map<String, String> data = new HashMap<String, String>();
    public String finalData = "";
    public Map<String, String> headers = new HashMap<String, String>();
    public String entityId = "";
    public String entityValue = "";
    public String expressionValue = "";

    public Entity(String endpointName) {
        this.endpointName = endpointName;
    }

    public Entity(String endpointName, String contentType) {
        this.endpointName = endpointName;
        this.contentType = contentType;
    }

    @Override
    public Boolean config() throws DataNotValid, DataNotFound {
        this.headers.put("Authorization", "Bearer " + this.accessToken);
        this.headers.put("Content-Type", this.contentType);
        if (this.endpointName.equals(EntityEndpoint.GET_ENTITIES)) {
            this.url = EntityEndpoint.GET_ENTITIES_ENDPOINT;
            this.method = EntityEndpoint.GET_ENTITIES_METHOD;
        } else if (this.endpointName.equals(EntityEndpoint.CREATE_ENTITY)) {
            this.url = EntityEndpoint.CREATE_ENTITY_ENDPOINT;
            this.method = EntityEndpoint.CREATE_ENTITY_METHOD;
        } else if (this.endpointName.equals(EntityEndpoint.GET_ENTITY)) {
            this.url = EntityEndpoint.GET_ENTITY_ENDPOINT;
            this.method = EntityEndpoint.GET_ENTITY_METHOD;
        } else if (this.endpointName.equals(EntityEndpoint.UPDATE_ENTITY)) {
            this.url = EntityEndpoint.UPDATE_ENTITY_ENDPOINT;
            this.method = EntityEndpoint.UPDATE_ENTITY_METHOD;
        } else if (this.endpointName.equals(EntityEndpoint.DELETE_ENTITY)) {
            this.url = EntityEndpoint.DELETE_ENTITY_ENDPOINT;
            this.method = EntityEndpoint.DELETE_ENTITY_METHOD;
        } else if (this.endpointName.equals(EntityEndpoint.CREATE_ENTITY_VALUE)) {
            this.url = EntityEndpoint.CREATE_ENTITY_VALUE_ENDPOINT;
            this.method = EntityEndpoint.CREATE_ENTITY_VALUE_METHOD;
        } else if (this.endpointName.equals(EntityEndpoint.DELETE_ENTITY_VALUE)) {
            this.url = EntityEndpoint.DELETE_ENTITY_VALUE_ENDPOINT;
            this.method = EntityEndpoint.DELETE_ENTITY_VALUE_METHOD;
        } else if (this.endpointName.equals(EntityEndpoint.CREATE_ENTITY_VALUE_EXPRESSION)) {
            this.url = EntityEndpoint.CREATE_ENTITY_VALUE_EXPRESSION_ENDPOINT;
            this.method = EntityEndpoint.CREATE_ENTITY_VALUE_EXPRESSION_METHOD;
        } else if (this.endpointName.equals(EntityEndpoint.DELETE_ENTITY_VALUE_EXPRESSION)) {
            this.url = EntityEndpoint.DELETE_ENTITY_VALUE_EXPRESSION_ENDPOINT;
            this.method = EntityEndpoint.DELETE_ENTITY_VALUE_EXPRESSION_METHOD;
        } else {
            Logger.error((String)"Error! Invalid endpointName Value.");
            throw new DataNotValid("Error! Invalid endpointName Value.");
        }
        if (!this.data.isEmpty()) {
            this.finalData = this.finalData + "{";
            for (Map.Entry<String, String> entry : this.data.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                value = value.indexOf("||") > 0 && !value.startsWith("{") && !value.endsWith("}") ? "[\"" + value.replace("||", "\",\"") + "\"]" : (value.indexOf("||") > 0 && value.startsWith("{") && value.endsWith("}") ? "[" + value.replace("||", ",") + "]" : "\"" + value + "\"");
                this.finalData = this.finalData + "\"" + key + "\":" + value + ",";
            }
            this.finalData = this.finalData.replaceAll(",$", "");
            this.finalData = this.finalData + "}";
        }
        this.url = this.url.replace("{$ENTITY_ID}", this.entityId);
        this.url = this.url.replace("{$ENTITY_VALUE}", this.entityValue);
        this.url = this.url.replace("{$EXPRESSION_VALUE}", this.expressionValue);
        return true;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getData() {
        return this.finalData;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public void setAppId(String appId) {
        if (this.appId.equals("")) {
            this.appId = appId;
        }
    }

    @Override
    public void setAccessToken(String accessToken) {
        if (this.accessToken.equals("")) {
            this.accessToken = accessToken;
        }
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setEntityValue(String entityValue) {
        this.entityValue = entityValue;
    }

    public void setExpressionValue(String expressionValue) {
        this.expressionValue = expressionValue;
    }

    public void setId(String id) {
        this.data.put("id", id);
    }

    public void setDoc(String doc) {
        this.data.put("doc", doc);
    }

    public void setValues(String[] values) {
        this.data.put("values", String.join((CharSequence)"||", values));
    }

    public void setValue(String value) {
        this.data.put("value", value);
    }

    public void setExpressions(String[] expressions) {
        this.data.put("expressions", String.join((CharSequence)"||", expressions));
    }

    public void setMetadata(String metadata) {
        this.data.put("metadata", metadata);
    }

    public void setExpression(String expression) {
        this.data.put("expression", expression);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityValue() {
        return this.entityValue;
    }

    public String getExpressionValue() {
        return this.expressionValue;
    }

    public String getId() {
        return this.data.containsKey("id") ? this.data.get("id") : "";
    }

    public String getDoc() {
        return this.data.containsKey("doc") ? this.data.get("doc") : "";
    }

    public String[] getValues() {
        return this.data.containsKey("values") ? this.data.get("values").split("||") : new String[]{};
    }

    public String getValue() {
        return this.data.containsKey("value") ? this.data.get("value") : "";
    }

    public String[] getExpressions() {
        return this.data.containsKey("expressions") ? this.data.get("expressions").split("||") : new String[]{};
    }

    public String getMetadata() {
        return this.data.containsKey("metadata") ? this.data.get("metadata") : "";
    }

    public String getExpression() {
        return this.data.containsKey("expression") ? this.data.get("expression") : "";
    }

    @Override
    public String debug() {
        String debug = "> curl -X" + this.method + " '" + this.url + "'";
        if (!this.headers.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value.indexOf("||") > 0) {
                    value = "[\"" + value.replace("||", "\",\"") + "\"]";
                }
                debug = debug + " -H \"" + key + ": " + value + "\"";
            }
        }
        if (!this.getData().equals("")) {
            debug = debug + " -d '" + this.getData() + "'";
        }
        return debug;
    }
}

