/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client;

import java.io.IOException;
import java.lang.reflect.Method;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;

public final class ForceChunkedMultipartInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        final RequestBody body = request.body();
        if (body == null) {
            return chain.proceed(request);
        }
        MediaType ct = body.contentType();
        if (ct == null || !"multipart".equalsIgnoreCase(ct.type())) {
            return chain.proceed(request);
        }
        RequestBody chunkedBody = new RequestBody(){

            public MediaType contentType() {
                return body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                body.writeTo(sink);
            }

            public boolean isOneShot() {
                try {
                    Method m = body.getClass().getMethod("isOneShot", new Class[0]);
                    Object v = m.invoke((Object)body, new Object[0]);
                    return v instanceof Boolean ? (Boolean)v : false;
                }
                catch (Exception ignore) {
                    return false;
                }
            }
        };
        Request newRequest = request.newBuilder().method(request.method(), chunkedBody).removeHeader("Content-Length").build();
        return chain.proceed(newRequest);
    }
}

