/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.time.Duration;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.CloudStorageAdvancedVirusScanResult;
import org.openapitools.client.model.CloudStorageVirusScanResult;
import org.openapitools.client.model.ScanCloudStorageBatchJobCreateResult;
import org.openapitools.client.model.ScanCloudStorageJobStatusResult;

public class ScanCloudStorageApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public ScanCloudStorageApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScanCloudStorageApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public ScanCloudStorageJobStatusResult scanCloudStorageGetAsyncJobStatus(String asyncJobID) throws ApiException {
        ApiResponse<ScanCloudStorageJobStatusResult> localVarResponse = this.scanCloudStorageGetAsyncJobStatusWithHttpInfo(asyncJobID);
        return localVarResponse.getData();
    }

    public ApiResponse<ScanCloudStorageJobStatusResult> scanCloudStorageGetAsyncJobStatusWithHttpInfo(String asyncJobID) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageGetAsyncJobStatusRequestBuilder(asyncJobID);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageGetAsyncJobStatus", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (ScanCloudStorageJobStatusResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ScanCloudStorageJobStatusResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageGetAsyncJobStatusRequestBuilder(String asyncJobID) throws ApiException {
        if (asyncJobID == null) {
            throw new ApiException(400, "Missing the required parameter 'asyncJobID' when calling scanCloudStorageGetAsyncJobStatus");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/batch-job/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "AsyncJobID";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("AsyncJobID", asyncJobID));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CloudStorageVirusScanResult scanCloudStorageScanAwsS3File(String accessKey, String secretKey, String bucketRegion, String bucketName, String keyName, String roleArn) throws ApiException {
        ApiResponse<CloudStorageVirusScanResult> localVarResponse = this.scanCloudStorageScanAwsS3FileWithHttpInfo(accessKey, secretKey, bucketRegion, bucketName, keyName, roleArn);
        return localVarResponse.getData();
    }

    public ApiResponse<CloudStorageVirusScanResult> scanCloudStorageScanAwsS3FileWithHttpInfo(String accessKey, String secretKey, String bucketRegion, String bucketName, String keyName, String roleArn) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanAwsS3FileRequestBuilder(accessKey, secretKey, bucketRegion, bucketName, keyName, roleArn);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanAwsS3File", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (CloudStorageVirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CloudStorageVirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanAwsS3FileRequestBuilder(String accessKey, String secretKey, String bucketRegion, String bucketName, String keyName, String roleArn) throws ApiException {
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling scanCloudStorageScanAwsS3File");
        }
        if (secretKey == null) {
            throw new ApiException(400, "Missing the required parameter 'secretKey' when calling scanCloudStorageScanAwsS3File");
        }
        if (bucketRegion == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketRegion' when calling scanCloudStorageScanAwsS3File");
        }
        if (bucketName == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketName' when calling scanCloudStorageScanAwsS3File");
        }
        if (keyName == null) {
            throw new ApiException(400, "Missing the required parameter 'keyName' when calling scanCloudStorageScanAwsS3File");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/aws-s3/single";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (accessKey != null) {
            localVarRequestBuilder.header("accessKey", accessKey.toString());
        }
        if (secretKey != null) {
            localVarRequestBuilder.header("secretKey", secretKey.toString());
        }
        if (bucketRegion != null) {
            localVarRequestBuilder.header("bucketRegion", bucketRegion.toString());
        }
        if (bucketName != null) {
            localVarRequestBuilder.header("bucketName", bucketName.toString());
        }
        if (keyName != null) {
            localVarRequestBuilder.header("keyName", keyName.toString());
        }
        if (roleArn != null) {
            localVarRequestBuilder.header("roleArn", roleArn.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CloudStorageAdvancedVirusScanResult scanCloudStorageScanAwsS3FileAdvanced(String accessKey, String secretKey, String bucketRegion, String bucketName, String keyName, String roleArn, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        ApiResponse<CloudStorageAdvancedVirusScanResult> localVarResponse = this.scanCloudStorageScanAwsS3FileAdvancedWithHttpInfo(accessKey, secretKey, bucketRegion, bucketName, keyName, roleArn, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        return localVarResponse.getData();
    }

    public ApiResponse<CloudStorageAdvancedVirusScanResult> scanCloudStorageScanAwsS3FileAdvancedWithHttpInfo(String accessKey, String secretKey, String bucketRegion, String bucketName, String keyName, String roleArn, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanAwsS3FileAdvancedRequestBuilder(accessKey, secretKey, bucketRegion, bucketName, keyName, roleArn, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanAwsS3FileAdvanced", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (CloudStorageAdvancedVirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CloudStorageAdvancedVirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanAwsS3FileAdvancedRequestBuilder(String accessKey, String secretKey, String bucketRegion, String bucketName, String keyName, String roleArn, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling scanCloudStorageScanAwsS3FileAdvanced");
        }
        if (secretKey == null) {
            throw new ApiException(400, "Missing the required parameter 'secretKey' when calling scanCloudStorageScanAwsS3FileAdvanced");
        }
        if (bucketRegion == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketRegion' when calling scanCloudStorageScanAwsS3FileAdvanced");
        }
        if (bucketName == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketName' when calling scanCloudStorageScanAwsS3FileAdvanced");
        }
        if (keyName == null) {
            throw new ApiException(400, "Missing the required parameter 'keyName' when calling scanCloudStorageScanAwsS3FileAdvanced");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/aws-s3/single/advanced";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (accessKey != null) {
            localVarRequestBuilder.header("accessKey", accessKey.toString());
        }
        if (secretKey != null) {
            localVarRequestBuilder.header("secretKey", secretKey.toString());
        }
        if (bucketRegion != null) {
            localVarRequestBuilder.header("bucketRegion", bucketRegion.toString());
        }
        if (bucketName != null) {
            localVarRequestBuilder.header("bucketName", bucketName.toString());
        }
        if (keyName != null) {
            localVarRequestBuilder.header("keyName", keyName.toString());
        }
        if (roleArn != null) {
            localVarRequestBuilder.header("roleArn", roleArn.toString());
        }
        if (allowExecutables != null) {
            localVarRequestBuilder.header("allowExecutables", allowExecutables.toString());
        }
        if (allowInvalidFiles != null) {
            localVarRequestBuilder.header("allowInvalidFiles", allowInvalidFiles.toString());
        }
        if (allowScripts != null) {
            localVarRequestBuilder.header("allowScripts", allowScripts.toString());
        }
        if (allowPasswordProtectedFiles != null) {
            localVarRequestBuilder.header("allowPasswordProtectedFiles", allowPasswordProtectedFiles.toString());
        }
        if (allowMacros != null) {
            localVarRequestBuilder.header("allowMacros", allowMacros.toString());
        }
        if (allowXmlExternalEntities != null) {
            localVarRequestBuilder.header("allowXmlExternalEntities", allowXmlExternalEntities.toString());
        }
        if (allowInsecureDeserialization != null) {
            localVarRequestBuilder.header("allowInsecureDeserialization", allowInsecureDeserialization.toString());
        }
        if (allowHtml != null) {
            localVarRequestBuilder.header("allowHtml", allowHtml.toString());
        }
        if (allowUnsafeArchives != null) {
            localVarRequestBuilder.header("allowUnsafeArchives", allowUnsafeArchives.toString());
        }
        if (allowOleEmbeddedObject != null) {
            localVarRequestBuilder.header("allowOleEmbeddedObject", allowOleEmbeddedObject.toString());
        }
        if (allowUnwantedAction != null) {
            localVarRequestBuilder.header("allowUnwantedAction", allowUnwantedAction.toString());
        }
        if (options != null) {
            localVarRequestBuilder.header("options", options.toString());
        }
        if (restrictFileTypes != null) {
            localVarRequestBuilder.header("restrictFileTypes", restrictFileTypes.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CloudStorageVirusScanResult scanCloudStorageScanAzureBlob(String connectionString, String containerName, String blobPath) throws ApiException {
        ApiResponse<CloudStorageVirusScanResult> localVarResponse = this.scanCloudStorageScanAzureBlobWithHttpInfo(connectionString, containerName, blobPath);
        return localVarResponse.getData();
    }

    public ApiResponse<CloudStorageVirusScanResult> scanCloudStorageScanAzureBlobWithHttpInfo(String connectionString, String containerName, String blobPath) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanAzureBlobRequestBuilder(connectionString, containerName, blobPath);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanAzureBlob", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (CloudStorageVirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CloudStorageVirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanAzureBlobRequestBuilder(String connectionString, String containerName, String blobPath) throws ApiException {
        if (connectionString == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionString' when calling scanCloudStorageScanAzureBlob");
        }
        if (containerName == null) {
            throw new ApiException(400, "Missing the required parameter 'containerName' when calling scanCloudStorageScanAzureBlob");
        }
        if (blobPath == null) {
            throw new ApiException(400, "Missing the required parameter 'blobPath' when calling scanCloudStorageScanAzureBlob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/azure-blob/single";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (connectionString != null) {
            localVarRequestBuilder.header("connectionString", connectionString.toString());
        }
        if (containerName != null) {
            localVarRequestBuilder.header("containerName", containerName.toString());
        }
        if (blobPath != null) {
            localVarRequestBuilder.header("blobPath", blobPath.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CloudStorageAdvancedVirusScanResult scanCloudStorageScanAzureBlobAdvanced(String connectionString, String containerName, String blobPath, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        ApiResponse<CloudStorageAdvancedVirusScanResult> localVarResponse = this.scanCloudStorageScanAzureBlobAdvancedWithHttpInfo(connectionString, containerName, blobPath, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        return localVarResponse.getData();
    }

    public ApiResponse<CloudStorageAdvancedVirusScanResult> scanCloudStorageScanAzureBlobAdvancedWithHttpInfo(String connectionString, String containerName, String blobPath, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanAzureBlobAdvancedRequestBuilder(connectionString, containerName, blobPath, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanAzureBlobAdvanced", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (CloudStorageAdvancedVirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CloudStorageAdvancedVirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanAzureBlobAdvancedRequestBuilder(String connectionString, String containerName, String blobPath, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        if (connectionString == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionString' when calling scanCloudStorageScanAzureBlobAdvanced");
        }
        if (containerName == null) {
            throw new ApiException(400, "Missing the required parameter 'containerName' when calling scanCloudStorageScanAzureBlobAdvanced");
        }
        if (blobPath == null) {
            throw new ApiException(400, "Missing the required parameter 'blobPath' when calling scanCloudStorageScanAzureBlobAdvanced");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/azure-blob/single/advanced";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (connectionString != null) {
            localVarRequestBuilder.header("connectionString", connectionString.toString());
        }
        if (containerName != null) {
            localVarRequestBuilder.header("containerName", containerName.toString());
        }
        if (blobPath != null) {
            localVarRequestBuilder.header("blobPath", blobPath.toString());
        }
        if (allowExecutables != null) {
            localVarRequestBuilder.header("allowExecutables", allowExecutables.toString());
        }
        if (allowInvalidFiles != null) {
            localVarRequestBuilder.header("allowInvalidFiles", allowInvalidFiles.toString());
        }
        if (allowScripts != null) {
            localVarRequestBuilder.header("allowScripts", allowScripts.toString());
        }
        if (allowPasswordProtectedFiles != null) {
            localVarRequestBuilder.header("allowPasswordProtectedFiles", allowPasswordProtectedFiles.toString());
        }
        if (allowMacros != null) {
            localVarRequestBuilder.header("allowMacros", allowMacros.toString());
        }
        if (allowXmlExternalEntities != null) {
            localVarRequestBuilder.header("allowXmlExternalEntities", allowXmlExternalEntities.toString());
        }
        if (allowInsecureDeserialization != null) {
            localVarRequestBuilder.header("allowInsecureDeserialization", allowInsecureDeserialization.toString());
        }
        if (allowHtml != null) {
            localVarRequestBuilder.header("allowHtml", allowHtml.toString());
        }
        if (allowUnsafeArchives != null) {
            localVarRequestBuilder.header("allowUnsafeArchives", allowUnsafeArchives.toString());
        }
        if (allowOleEmbeddedObject != null) {
            localVarRequestBuilder.header("allowOleEmbeddedObject", allowOleEmbeddedObject.toString());
        }
        if (allowUnwantedAction != null) {
            localVarRequestBuilder.header("allowUnwantedAction", allowUnwantedAction.toString());
        }
        if (options != null) {
            localVarRequestBuilder.header("options", options.toString());
        }
        if (restrictFileTypes != null) {
            localVarRequestBuilder.header("restrictFileTypes", restrictFileTypes.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ScanCloudStorageBatchJobCreateResult scanCloudStorageScanAzureBlobAdvancedBatchJob(String connectionString, String containerName, String blobPath, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        ApiResponse<ScanCloudStorageBatchJobCreateResult> localVarResponse = this.scanCloudStorageScanAzureBlobAdvancedBatchJobWithHttpInfo(connectionString, containerName, blobPath, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        return localVarResponse.getData();
    }

    public ApiResponse<ScanCloudStorageBatchJobCreateResult> scanCloudStorageScanAzureBlobAdvancedBatchJobWithHttpInfo(String connectionString, String containerName, String blobPath, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanAzureBlobAdvancedBatchJobRequestBuilder(connectionString, containerName, blobPath, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanAzureBlobAdvancedBatchJob", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (ScanCloudStorageBatchJobCreateResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ScanCloudStorageBatchJobCreateResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanAzureBlobAdvancedBatchJobRequestBuilder(String connectionString, String containerName, String blobPath, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        if (connectionString == null) {
            throw new ApiException(400, "Missing the required parameter 'connectionString' when calling scanCloudStorageScanAzureBlobAdvancedBatchJob");
        }
        if (containerName == null) {
            throw new ApiException(400, "Missing the required parameter 'containerName' when calling scanCloudStorageScanAzureBlobAdvancedBatchJob");
        }
        if (blobPath == null) {
            throw new ApiException(400, "Missing the required parameter 'blobPath' when calling scanCloudStorageScanAzureBlobAdvancedBatchJob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/azure-blob/single/advanced/batch-job";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (connectionString != null) {
            localVarRequestBuilder.header("connectionString", connectionString.toString());
        }
        if (containerName != null) {
            localVarRequestBuilder.header("containerName", containerName.toString());
        }
        if (blobPath != null) {
            localVarRequestBuilder.header("blobPath", blobPath.toString());
        }
        if (allowExecutables != null) {
            localVarRequestBuilder.header("allowExecutables", allowExecutables.toString());
        }
        if (allowInvalidFiles != null) {
            localVarRequestBuilder.header("allowInvalidFiles", allowInvalidFiles.toString());
        }
        if (allowScripts != null) {
            localVarRequestBuilder.header("allowScripts", allowScripts.toString());
        }
        if (allowPasswordProtectedFiles != null) {
            localVarRequestBuilder.header("allowPasswordProtectedFiles", allowPasswordProtectedFiles.toString());
        }
        if (allowMacros != null) {
            localVarRequestBuilder.header("allowMacros", allowMacros.toString());
        }
        if (allowXmlExternalEntities != null) {
            localVarRequestBuilder.header("allowXmlExternalEntities", allowXmlExternalEntities.toString());
        }
        if (allowInsecureDeserialization != null) {
            localVarRequestBuilder.header("allowInsecureDeserialization", allowInsecureDeserialization.toString());
        }
        if (allowHtml != null) {
            localVarRequestBuilder.header("allowHtml", allowHtml.toString());
        }
        if (allowUnsafeArchives != null) {
            localVarRequestBuilder.header("allowUnsafeArchives", allowUnsafeArchives.toString());
        }
        if (allowOleEmbeddedObject != null) {
            localVarRequestBuilder.header("allowOleEmbeddedObject", allowOleEmbeddedObject.toString());
        }
        if (allowUnwantedAction != null) {
            localVarRequestBuilder.header("allowUnwantedAction", allowUnwantedAction.toString());
        }
        if (options != null) {
            localVarRequestBuilder.header("options", options.toString());
        }
        if (restrictFileTypes != null) {
            localVarRequestBuilder.header("restrictFileTypes", restrictFileTypes.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CloudStorageVirusScanResult scanCloudStorageScanGcpStorageFile(String bucketName, String objectName, File jsonCredentialFile) throws ApiException {
        ApiResponse<CloudStorageVirusScanResult> localVarResponse = this.scanCloudStorageScanGcpStorageFileWithHttpInfo(bucketName, objectName, jsonCredentialFile);
        return localVarResponse.getData();
    }

    public ApiResponse<CloudStorageVirusScanResult> scanCloudStorageScanGcpStorageFileWithHttpInfo(String bucketName, String objectName, File jsonCredentialFile) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanGcpStorageFileRequestBuilder(bucketName, objectName, jsonCredentialFile);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanGcpStorageFile", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (CloudStorageVirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CloudStorageVirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanGcpStorageFileRequestBuilder(String bucketName, String objectName, File jsonCredentialFile) throws ApiException {
        HttpRequest.BodyPublisher formDataPublisher;
        if (bucketName == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketName' when calling scanCloudStorageScanGcpStorageFile");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling scanCloudStorageScanGcpStorageFile");
        }
        if (jsonCredentialFile == null) {
            throw new ApiException(400, "Missing the required parameter 'jsonCredentialFile' when calling scanCloudStorageScanGcpStorageFile");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/gcp-storage/single";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (bucketName != null) {
            localVarRequestBuilder.header("bucketName", bucketName.toString());
        }
        if (objectName != null) {
            localVarRequestBuilder.header("objectName", objectName.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
        boolean hasFiles = false;
        multiPartBuilder.addBinaryBody("jsonCredentialFile", jsonCredentialFile);
        hasFiles = true;
        HttpEntity entity = multiPartBuilder.build();
        if (ApiClient.isChunkedTransferEnabled()) {
            Pipe pipe;
            try {
                pipe = Pipe.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            new Thread(() -> {
                try (OutputStream outputStream = Channels.newOutputStream(pipe.sink());){
                    entity.writeTo(outputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).start();
            formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()));
        } else {
            ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
            try {
                entity.writeTo((OutputStream)formOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            formDataPublisher = HttpRequest.BodyPublishers.ofByteArray(formOutputStream.toByteArray());
        }
        localVarRequestBuilder.header("Content-Type", entity.getContentType().getValue()).method("POST", formDataPublisher);
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CloudStorageAdvancedVirusScanResult scanCloudStorageScanGcpStorageFileAdvanced(String bucketName, String objectName, File jsonCredentialFile, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        ApiResponse<CloudStorageAdvancedVirusScanResult> localVarResponse = this.scanCloudStorageScanGcpStorageFileAdvancedWithHttpInfo(bucketName, objectName, jsonCredentialFile, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        return localVarResponse.getData();
    }

    public ApiResponse<CloudStorageAdvancedVirusScanResult> scanCloudStorageScanGcpStorageFileAdvancedWithHttpInfo(String bucketName, String objectName, File jsonCredentialFile, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanGcpStorageFileAdvancedRequestBuilder(bucketName, objectName, jsonCredentialFile, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, options, restrictFileTypes);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanGcpStorageFileAdvanced", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (CloudStorageAdvancedVirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CloudStorageAdvancedVirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanGcpStorageFileAdvancedRequestBuilder(String bucketName, String objectName, File jsonCredentialFile, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String options, String restrictFileTypes) throws ApiException {
        HttpRequest.BodyPublisher formDataPublisher;
        if (bucketName == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketName' when calling scanCloudStorageScanGcpStorageFileAdvanced");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling scanCloudStorageScanGcpStorageFileAdvanced");
        }
        if (jsonCredentialFile == null) {
            throw new ApiException(400, "Missing the required parameter 'jsonCredentialFile' when calling scanCloudStorageScanGcpStorageFileAdvanced");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/gcp-storage/single/advanced";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (bucketName != null) {
            localVarRequestBuilder.header("bucketName", bucketName.toString());
        }
        if (objectName != null) {
            localVarRequestBuilder.header("objectName", objectName.toString());
        }
        if (allowExecutables != null) {
            localVarRequestBuilder.header("allowExecutables", allowExecutables.toString());
        }
        if (allowInvalidFiles != null) {
            localVarRequestBuilder.header("allowInvalidFiles", allowInvalidFiles.toString());
        }
        if (allowScripts != null) {
            localVarRequestBuilder.header("allowScripts", allowScripts.toString());
        }
        if (allowPasswordProtectedFiles != null) {
            localVarRequestBuilder.header("allowPasswordProtectedFiles", allowPasswordProtectedFiles.toString());
        }
        if (allowMacros != null) {
            localVarRequestBuilder.header("allowMacros", allowMacros.toString());
        }
        if (allowXmlExternalEntities != null) {
            localVarRequestBuilder.header("allowXmlExternalEntities", allowXmlExternalEntities.toString());
        }
        if (allowInsecureDeserialization != null) {
            localVarRequestBuilder.header("allowInsecureDeserialization", allowInsecureDeserialization.toString());
        }
        if (allowHtml != null) {
            localVarRequestBuilder.header("allowHtml", allowHtml.toString());
        }
        if (allowUnsafeArchives != null) {
            localVarRequestBuilder.header("allowUnsafeArchives", allowUnsafeArchives.toString());
        }
        if (allowOleEmbeddedObject != null) {
            localVarRequestBuilder.header("allowOleEmbeddedObject", allowOleEmbeddedObject.toString());
        }
        if (allowUnwantedAction != null) {
            localVarRequestBuilder.header("allowUnwantedAction", allowUnwantedAction.toString());
        }
        if (options != null) {
            localVarRequestBuilder.header("options", options.toString());
        }
        if (restrictFileTypes != null) {
            localVarRequestBuilder.header("restrictFileTypes", restrictFileTypes.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
        boolean hasFiles = false;
        multiPartBuilder.addBinaryBody("jsonCredentialFile", jsonCredentialFile);
        hasFiles = true;
        HttpEntity entity = multiPartBuilder.build();
        if (ApiClient.isChunkedTransferEnabled()) {
            Pipe pipe;
            try {
                pipe = Pipe.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            new Thread(() -> {
                try (OutputStream outputStream = Channels.newOutputStream(pipe.sink());){
                    entity.writeTo(outputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).start();
            formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()));
        } else {
            ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
            try {
                entity.writeTo((OutputStream)formOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            formDataPublisher = HttpRequest.BodyPublishers.ofByteArray(formOutputStream.toByteArray());
        }
        localVarRequestBuilder.header("Content-Type", entity.getContentType().getValue()).method("POST", formDataPublisher);
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CloudStorageVirusScanResult scanCloudStorageScanSharePointOnlineFile(String clientID, String clientSecret, String sharepointDomainName, String siteID, String filePath, String tenantID, String itemID) throws ApiException {
        ApiResponse<CloudStorageVirusScanResult> localVarResponse = this.scanCloudStorageScanSharePointOnlineFileWithHttpInfo(clientID, clientSecret, sharepointDomainName, siteID, filePath, tenantID, itemID);
        return localVarResponse.getData();
    }

    public ApiResponse<CloudStorageVirusScanResult> scanCloudStorageScanSharePointOnlineFileWithHttpInfo(String clientID, String clientSecret, String sharepointDomainName, String siteID, String filePath, String tenantID, String itemID) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanSharePointOnlineFileRequestBuilder(clientID, clientSecret, sharepointDomainName, siteID, filePath, tenantID, itemID);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanSharePointOnlineFile", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (CloudStorageVirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CloudStorageVirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanSharePointOnlineFileRequestBuilder(String clientID, String clientSecret, String sharepointDomainName, String siteID, String filePath, String tenantID, String itemID) throws ApiException {
        if (clientID == null) {
            throw new ApiException(400, "Missing the required parameter 'clientID' when calling scanCloudStorageScanSharePointOnlineFile");
        }
        if (clientSecret == null) {
            throw new ApiException(400, "Missing the required parameter 'clientSecret' when calling scanCloudStorageScanSharePointOnlineFile");
        }
        if (sharepointDomainName == null) {
            throw new ApiException(400, "Missing the required parameter 'sharepointDomainName' when calling scanCloudStorageScanSharePointOnlineFile");
        }
        if (siteID == null) {
            throw new ApiException(400, "Missing the required parameter 'siteID' when calling scanCloudStorageScanSharePointOnlineFile");
        }
        if (filePath == null) {
            throw new ApiException(400, "Missing the required parameter 'filePath' when calling scanCloudStorageScanSharePointOnlineFile");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/sharepoint-online/site/single";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (clientID != null) {
            localVarRequestBuilder.header("clientID", clientID.toString());
        }
        if (clientSecret != null) {
            localVarRequestBuilder.header("clientSecret", clientSecret.toString());
        }
        if (sharepointDomainName != null) {
            localVarRequestBuilder.header("sharepointDomainName", sharepointDomainName.toString());
        }
        if (siteID != null) {
            localVarRequestBuilder.header("siteID", siteID.toString());
        }
        if (tenantID != null) {
            localVarRequestBuilder.header("tenantID", tenantID.toString());
        }
        if (filePath != null) {
            localVarRequestBuilder.header("filePath", filePath.toString());
        }
        if (itemID != null) {
            localVarRequestBuilder.header("itemID", itemID.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CloudStorageAdvancedVirusScanResult scanCloudStorageScanSharePointOnlineFileAdvanced(String clientID, String clientSecret, String sharepointDomainName, String siteID, String tenantID, String filePath, String itemID, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String restrictFileTypes) throws ApiException {
        ApiResponse<CloudStorageAdvancedVirusScanResult> localVarResponse = this.scanCloudStorageScanSharePointOnlineFileAdvancedWithHttpInfo(clientID, clientSecret, sharepointDomainName, siteID, tenantID, filePath, itemID, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, restrictFileTypes);
        return localVarResponse.getData();
    }

    public ApiResponse<CloudStorageAdvancedVirusScanResult> scanCloudStorageScanSharePointOnlineFileAdvancedWithHttpInfo(String clientID, String clientSecret, String sharepointDomainName, String siteID, String tenantID, String filePath, String itemID, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String restrictFileTypes) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.scanCloudStorageScanSharePointOnlineFileAdvancedRequestBuilder(clientID, clientSecret, sharepointDomainName, siteID, tenantID, filePath, itemID, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, allowMacros, allowXmlExternalEntities, allowInsecureDeserialization, allowHtml, allowUnsafeArchives, allowOleEmbeddedObject, allowUnwantedAction, restrictFileTypes);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("scanCloudStorageScanSharePointOnlineFileAdvanced", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (CloudStorageAdvancedVirusScanResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CloudStorageAdvancedVirusScanResult>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder scanCloudStorageScanSharePointOnlineFileAdvancedRequestBuilder(String clientID, String clientSecret, String sharepointDomainName, String siteID, String tenantID, String filePath, String itemID, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, Boolean allowMacros, Boolean allowXmlExternalEntities, Boolean allowInsecureDeserialization, Boolean allowHtml, Boolean allowUnsafeArchives, Boolean allowOleEmbeddedObject, Boolean allowUnwantedAction, String restrictFileTypes) throws ApiException {
        if (clientID == null) {
            throw new ApiException(400, "Missing the required parameter 'clientID' when calling scanCloudStorageScanSharePointOnlineFileAdvanced");
        }
        if (clientSecret == null) {
            throw new ApiException(400, "Missing the required parameter 'clientSecret' when calling scanCloudStorageScanSharePointOnlineFileAdvanced");
        }
        if (sharepointDomainName == null) {
            throw new ApiException(400, "Missing the required parameter 'sharepointDomainName' when calling scanCloudStorageScanSharePointOnlineFileAdvanced");
        }
        if (siteID == null) {
            throw new ApiException(400, "Missing the required parameter 'siteID' when calling scanCloudStorageScanSharePointOnlineFileAdvanced");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/virus/scan/cloud-storage/sharepoint-online/site/advanced";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (clientID != null) {
            localVarRequestBuilder.header("clientID", clientID.toString());
        }
        if (clientSecret != null) {
            localVarRequestBuilder.header("clientSecret", clientSecret.toString());
        }
        if (sharepointDomainName != null) {
            localVarRequestBuilder.header("sharepointDomainName", sharepointDomainName.toString());
        }
        if (siteID != null) {
            localVarRequestBuilder.header("siteID", siteID.toString());
        }
        if (tenantID != null) {
            localVarRequestBuilder.header("tenantID", tenantID.toString());
        }
        if (filePath != null) {
            localVarRequestBuilder.header("filePath", filePath.toString());
        }
        if (itemID != null) {
            localVarRequestBuilder.header("itemID", itemID.toString());
        }
        if (allowExecutables != null) {
            localVarRequestBuilder.header("allowExecutables", allowExecutables.toString());
        }
        if (allowInvalidFiles != null) {
            localVarRequestBuilder.header("allowInvalidFiles", allowInvalidFiles.toString());
        }
        if (allowScripts != null) {
            localVarRequestBuilder.header("allowScripts", allowScripts.toString());
        }
        if (allowPasswordProtectedFiles != null) {
            localVarRequestBuilder.header("allowPasswordProtectedFiles", allowPasswordProtectedFiles.toString());
        }
        if (allowMacros != null) {
            localVarRequestBuilder.header("allowMacros", allowMacros.toString());
        }
        if (allowXmlExternalEntities != null) {
            localVarRequestBuilder.header("allowXmlExternalEntities", allowXmlExternalEntities.toString());
        }
        if (allowInsecureDeserialization != null) {
            localVarRequestBuilder.header("allowInsecureDeserialization", allowInsecureDeserialization.toString());
        }
        if (allowHtml != null) {
            localVarRequestBuilder.header("allowHtml", allowHtml.toString());
        }
        if (allowUnsafeArchives != null) {
            localVarRequestBuilder.header("allowUnsafeArchives", allowUnsafeArchives.toString());
        }
        if (allowOleEmbeddedObject != null) {
            localVarRequestBuilder.header("allowOleEmbeddedObject", allowOleEmbeddedObject.toString());
        }
        if (allowUnwantedAction != null) {
            localVarRequestBuilder.header("allowUnwantedAction", allowUnwantedAction.toString());
        }
        if (restrictFileTypes != null) {
            localVarRequestBuilder.header("restrictFileTypes", restrictFileTypes.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json, text/json, application/xml, text/xml");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

