/*
 * Decompiled with CFR 0.152.
 */
package codacy.api.request;

import codacy.api.util.SSLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class ApiRequest {
    private String scheme = null;
    private String url = null;
    private int port = 80;

    public ApiRequest(String scheme, String url, int port) {
        this.scheme = scheme;
        this.url = url;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request(String requestType, String endpoint, HashMap<String, String> parameters) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException, IOException, URISyntaxException {
        HttpURLConnection conn = null;
        try {
            ArrayList<BasicNameValuePair> nameValues = new ArrayList<BasicNameValuePair>();
            for (String identifier : parameters.keySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(identifier, parameters.get(identifier));
                nameValues.add(pair);
            }
            URI uri = new URIBuilder().setScheme(this.scheme).setHost(this.url).setPort(this.port).setPath(endpoint).setParameters(nameValues).build();
            if (this.scheme.equals("https")) {
                SSLSocketFactory factory = SSLHelper.getSSLFactory();
                HttpsURLConnection httpsConn = (HttpsURLConnection)uri.toURL().openConnection();
                httpsConn.setSSLSocketFactory(factory);
                httpsConn.setRequestMethod(requestType);
                httpsConn.setDoInput(true);
                httpsConn.setInstanceFollowRedirects(true);
                httpsConn.connect();
                conn = httpsConn;
            } else {
                HttpURLConnection httpConn = (HttpURLConnection)uri.toURL().openConnection();
                httpConn.setRequestMethod(requestType);
                httpConn.setDoInput(true);
                httpConn.setInstanceFollowRedirects(true);
                httpConn.connect();
                conn = httpConn;
            }
            StringWriter writer = new StringWriter();
            if (conn.getResponseCode() != 200) {
                IOUtils.copy((InputStream)conn.getErrorStream(), (Writer)writer, (String)"UTF-8");
                throw new IOException(writer.toString());
            }
            IOUtils.copy((InputStream)conn.getInputStream(), (Writer)writer, (String)"UTF-8");
            String string = writer.toString();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

