/*
 * Code Dx API
 * Code Dx provides a variety of REST APIs, allowing external applications and scripts to interface with core functionality. This guide documents the various REST resources provided by Code Dx.  ## Authentication  Authentication is a requirement when accessing API endpoints. There are two methods by which authentication may be performed.  ### API Keys  The primary method for authentication is passing an `API-Key` header containing a valid API key with all requests.  For example&#58;  `API-Key: 550e8400-e29b-41d4-a716-44665544000`  API keys may be generated by Code Dx admins. Once they are generated, in most cases, they behave like regular users. They will need to be assigned user roles for any projects they will be used with. Although it is possible to assign the *admin* [role](UserGuide.html#UserRolesConfiguration) to an API key, the recommendation is to avoid doing so unless absolutely necessary.  See the user guide for an overview about how to create and manage [API keys](UserGuide.html#APIKeysAdministration).  ### HTTP Basic Authentication  HTTP Basic authentication may be used to authenticate with the API as a regular user. This is accomplished by including an `Authorization` header containing a typical authorization credential.  ## Error Handling  ### Bad Requests  For API calls that accept input, invalid values will trigger an HTTP 400 Bad Request status code.  ### Server Errors  For any API call, if an unexpected error occurs, an HTTP 500 Internal Server Error status code will be returned. If an error message is available, the response will include a basic message body describing the error&#58;  ` {   \"error\": \"error message\" } `  The error property will contain a string message indicating the nature of the error.  ### Errors with Third-Party Applications  Sometimes Code Dx must communicate with third-party applications like JIRA, Git, and certain enterprise tools. Some users may have in-house versions of these with self-signed certificates which may not be \"trusted\". In these cases, the API will respond with an HTTP 502 BAD GATEWAY status. If this happens, refer to [Trusting Self-Signed Certificates](InstallGuide.html#TrustingSelfSignedCertificates) in the install guide.  ### API Unavailable  In special circumstances, particularly during the installation and update phases, the API will be unavailable. When the API is unavailable, all calls will return an HTTP 503 Service Unavailable status, and no actions or side effects will occur as a result of the calls.  ## Examples  Code Dx's API uses REST over HTTP. As such, you can use any language/utility that supports making HTTP requests to interact with the API. The examples below use <a href=\"https://curl.haxx.se/\" target=\"_blank\">curl</a>, a popular command-line utility, to do so.  First, you'll need to [generate an API Key](UserGuide.html#APIKeysAdministration). Second, while you can create projects through the API, these examples will assume that you've already created one. You'll need to know its project id number, which you can find by looking at the URL for the [Findings Page](UserGuide.html#Findings), which will end in a number.  **Note:** Many API endpoints require a JSON body in the request. Most JSON will contain double-quotes (`\"`) and spaces, which have special meaning when used on the command line. In order to ensure your JSON body is interpreted as a single argument, you must <a href=\"https://en.wikipedia.org/wiki/Escape_character\" target=\"_blank\">escape</a> it properly. For example, if you wanted to `POST` the following JSON body&#58;  ``` { \"name\": \"John Doe\" } ```  You would put a backslash (`\\`) before each double-quote (`\"`), and surround the whole thing with double-quotes&#58;  ``` \"{ \\\"name\\\": \\\"John Doe\\\" }\" ```  The outermost double-quotes tell the command-line interpreter that everything within them is to be treated as a single argument (as opposed to the usual space-separated behavior). The backslash before each inner double-quote tells the command-line interpreter that you mean the literal double-quote character, and not the end of the quoted argument.  In many *non-Windows* operating systems, you can also use a single-quote (`'`) to surround the argument, and skip the backslashes&#58;  ``` '{ \"name\": \"John Doe\" }' ```  The examples below will use the double-quotes and backslashes style, as it works on most (if not all) operating systems.  ### Running an Analysis  To start an analysis, you can run  ``` curl -F file1=@src.zip -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/analysis ```  Make sure you use your own values for the `src.zip` file, the API Key, the hostname for your Code Dx server, and the project id.  **Note:** This endpoint is not listed below due to a swagger limitation.  ### Retrieving Finding Data  There is a wide variety of data available for the findings of a project after running an analysis. Two examples are provided here.  ### Findings Table Data  You can retrieve the data that's used to populate the [findings table](UserGuide.html#FindingsTable)&#58;  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"sort\\\":{\\\"by\\\":\\\"id\\\",\\\"direction\\\":\\\"ascending\\\"},\\\"pagination\\\":{\\\"page\\\":1,\\\"perPage\\\":10}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/findings/table ```  Additional information about how to construct more useful filter and sort requests can be found in the documentation.  ### Finding Metadata  You can retrieve metadata for a finding, if you know the finding id. You can take the ID for a finding from the Findings Table&#58;  ``` curl -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/findings/<finding id> ```  ### Generating a Report  You can use the API to generate a PDF [report](UserGuide.html#GenerateReport).  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"config\\\":{\\\"summaryMode\\\":\\\"simple\\\",\\\"detailsMode\\\":\\\"simple\\\",\\\"includeResultDetails\\\":true,\\\"includeComments\\\":false}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/report/pdf ```  ## Generating a Client SDK  If you require a client SDK for Code Dx, you can generate one using [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen). Detailed instructions are available on the github page and our swagger spec can be found [here](swagger/swagger.json). 
 *
 * OpenAPI spec version: 3.5.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.codedx.client.model.Analysis;
import com.codedx.client.model.AnalysisDetails;
import com.codedx.client.model.AnalysisName;
import com.codedx.client.model.AnalysisPrepResponse;
import com.codedx.client.model.AnalysisQueryResponse;
import com.codedx.client.model.Enabled;
import java.io.File;
import com.codedx.client.model.FileUploadResponse;
import com.codedx.client.model.InputDisplayInfo;
import com.codedx.client.model.ProjectId;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalysisApi {
    private ApiClient apiClient;

    public AnalysisApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AnalysisApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for createAnalysisPrep
     * @param projectId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createAnalysisPrepCall(ProjectId projectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = projectId;

        // create path and map variables
        String localVarPath = "/api/analysis-prep";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createAnalysisPrepValidateBeforeCall(ProjectId projectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling createAnalysisPrep(Async)");
        }
        

        com.squareup.okhttp.Call call = createAnalysisPrepCall(projectId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create Analysis Prep
     * Create a new Analysis Prep associated with a particular project. If Git is configured on that project, the new Analysis Prep will automatically initialize an input corresponding to that configuration. 
     * @param projectId  (required)
     * @return AnalysisPrepResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AnalysisPrepResponse createAnalysisPrep(ProjectId projectId) throws ApiException {
        ApiResponse<AnalysisPrepResponse> resp = createAnalysisPrepWithHttpInfo(projectId);
        return resp.getData();
    }

    /**
     * Create Analysis Prep
     * Create a new Analysis Prep associated with a particular project. If Git is configured on that project, the new Analysis Prep will automatically initialize an input corresponding to that configuration. 
     * @param projectId  (required)
     * @return ApiResponse&lt;AnalysisPrepResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AnalysisPrepResponse> createAnalysisPrepWithHttpInfo(ProjectId projectId) throws ApiException {
        com.squareup.okhttp.Call call = createAnalysisPrepValidateBeforeCall(projectId, null, null);
        Type localVarReturnType = new TypeToken<AnalysisPrepResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create Analysis Prep (asynchronously)
     * Create a new Analysis Prep associated with a particular project. If Git is configured on that project, the new Analysis Prep will automatically initialize an input corresponding to that configuration. 
     * @param projectId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createAnalysisPrepAsync(ProjectId projectId, final ApiCallback<AnalysisPrepResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createAnalysisPrepValidateBeforeCall(projectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnalysisPrepResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteInput
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteInputCall(String prepId, String inputId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/analysis-prep/{prep-id}/{input-id}"
            .replaceAll("\\{" + "prep-id" + "\\}", apiClient.escapeString(prepId.toString()))
            .replaceAll("\\{" + "input-id" + "\\}", apiClient.escapeString(inputId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteInputValidateBeforeCall(String prepId, String inputId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'prepId' is set
        if (prepId == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling deleteInput(Async)");
        }
        
        // verify the required parameter 'inputId' is set
        if (inputId == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling deleteInput(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteInputCall(prepId, inputId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete Input
     * Note that depending on the timing of the deletion, one of two different endpoints should be used. If an input file has just begun to upload, but that request has not completed and returned an inputId, use the \&quot;pending\&quot; URL (this requires the input upload request to have specified a X-Client-Request-Id header). If the inputId is known (this will be the case most of the time), use the URL that includes an input-id parameter. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteInput(String prepId, String inputId) throws ApiException {
        deleteInputWithHttpInfo(prepId, inputId);
    }

    /**
     * Delete Input
     * Note that depending on the timing of the deletion, one of two different endpoints should be used. If an input file has just begun to upload, but that request has not completed and returned an inputId, use the \&quot;pending\&quot; URL (this requires the input upload request to have specified a X-Client-Request-Id header). If the inputId is known (this will be the case most of the time), use the URL that includes an input-id parameter. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteInputWithHttpInfo(String prepId, String inputId) throws ApiException {
        com.squareup.okhttp.Call call = deleteInputValidateBeforeCall(prepId, inputId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete Input (asynchronously)
     * Note that depending on the timing of the deletion, one of two different endpoints should be used. If an input file has just begun to upload, but that request has not completed and returned an inputId, use the \&quot;pending\&quot; URL (this requires the input upload request to have specified a X-Client-Request-Id header). If the inputId is known (this will be the case most of the time), use the URL that includes an input-id parameter. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteInputAsync(String prepId, String inputId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteInputValidateBeforeCall(prepId, inputId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deletePendingInput
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param xClientRequestId If the input-id is not known, and the \&quot;pending\&quot; URL is being used, this header should be set to the value used by the requrest which initiated the input file upload. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletePendingInputCall(String prepId, String xClientRequestId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/analysis-prep/{prep-id}/pending"
            .replaceAll("\\{" + "prep-id" + "\\}", apiClient.escapeString(prepId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xClientRequestId != null)
        localVarHeaderParams.put("X-Client-Request-Id", apiClient.parameterToString(xClientRequestId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletePendingInputValidateBeforeCall(String prepId, String xClientRequestId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'prepId' is set
        if (prepId == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling deletePendingInput(Async)");
        }
        
        // verify the required parameter 'xClientRequestId' is set
        if (xClientRequestId == null) {
            throw new ApiException("Missing the required parameter 'xClientRequestId' when calling deletePendingInput(Async)");
        }
        

        com.squareup.okhttp.Call call = deletePendingInputCall(prepId, xClientRequestId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete Input (pending)
     * Note that depending on the timing of the deletion, one of two different endpoints should be used. If an input file has just begun to upload, but that request has not completed and returned an inputId, use the \&quot;pending\&quot; URL (this requires the input upload request to have specified a X-Client-Request-Id header). If the inputId is known (this will be the case most of the time), use the URL that include an input-id parameter. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param xClientRequestId If the input-id is not known, and the \&quot;pending\&quot; URL is being used, this header should be set to the value used by the requrest which initiated the input file upload. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deletePendingInput(String prepId, String xClientRequestId) throws ApiException {
        deletePendingInputWithHttpInfo(prepId, xClientRequestId);
    }

    /**
     * Delete Input (pending)
     * Note that depending on the timing of the deletion, one of two different endpoints should be used. If an input file has just begun to upload, but that request has not completed and returned an inputId, use the \&quot;pending\&quot; URL (this requires the input upload request to have specified a X-Client-Request-Id header). If the inputId is known (this will be the case most of the time), use the URL that include an input-id parameter. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param xClientRequestId If the input-id is not known, and the \&quot;pending\&quot; URL is being used, this header should be set to the value used by the requrest which initiated the input file upload. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deletePendingInputWithHttpInfo(String prepId, String xClientRequestId) throws ApiException {
        com.squareup.okhttp.Call call = deletePendingInputValidateBeforeCall(prepId, xClientRequestId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete Input (pending) (asynchronously)
     * Note that depending on the timing of the deletion, one of two different endpoints should be used. If an input file has just begun to upload, but that request has not completed and returned an inputId, use the \&quot;pending\&quot; URL (this requires the input upload request to have specified a X-Client-Request-Id header). If the inputId is known (this will be the case most of the time), use the URL that include an input-id parameter. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param xClientRequestId If the input-id is not known, and the \&quot;pending\&quot; URL is being used, this header should be set to the value used by the requrest which initiated the input file upload. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletePendingInputAsync(String prepId, String xClientRequestId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletePendingInputValidateBeforeCall(prepId, xClientRequestId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getAllAnalysisDetails
     * @param projectId The ID of the project. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllAnalysisDetailsCall(Integer projectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/analyses"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllAnalysisDetailsValidateBeforeCall(Integer projectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getAllAnalysisDetails(Async)");
        }
        

        com.squareup.okhttp.Call call = getAllAnalysisDetailsCall(projectId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get All Analysis Details
     * Obtain analysis details for a project, such as start and finish times
     * @param projectId The ID of the project. (required)
     * @return List&lt;AnalysisDetails&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<AnalysisDetails> getAllAnalysisDetails(Integer projectId) throws ApiException {
        ApiResponse<List<AnalysisDetails>> resp = getAllAnalysisDetailsWithHttpInfo(projectId);
        return resp.getData();
    }

    /**
     * Get All Analysis Details
     * Obtain analysis details for a project, such as start and finish times
     * @param projectId The ID of the project. (required)
     * @return ApiResponse&lt;List&lt;AnalysisDetails&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<AnalysisDetails>> getAllAnalysisDetailsWithHttpInfo(Integer projectId) throws ApiException {
        com.squareup.okhttp.Call call = getAllAnalysisDetailsValidateBeforeCall(projectId, null, null);
        Type localVarReturnType = new TypeToken<List<AnalysisDetails>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get All Analysis Details (asynchronously)
     * Obtain analysis details for a project, such as start and finish times
     * @param projectId The ID of the project. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAllAnalysisDetailsAsync(Integer projectId, final ApiCallback<List<AnalysisDetails>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAllAnalysisDetailsValidateBeforeCall(projectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<AnalysisDetails>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAnalysisDetails
     * @param projectId The ID of the project. (required)
     * @param analysisId The ID of the analysis (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAnalysisDetailsCall(Integer projectId, Integer analysisId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/analyses/{analysis-id}"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()))
            .replaceAll("\\{" + "analysis-id" + "\\}", apiClient.escapeString(analysisId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAnalysisDetailsValidateBeforeCall(Integer projectId, Integer analysisId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getAnalysisDetails(Async)");
        }
        
        // verify the required parameter 'analysisId' is set
        if (analysisId == null) {
            throw new ApiException("Missing the required parameter 'analysisId' when calling getAnalysisDetails(Async)");
        }
        

        com.squareup.okhttp.Call call = getAnalysisDetailsCall(projectId, analysisId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get Analysis Details
     * Obtain analysis details, such as start and finish times
     * @param projectId The ID of the project. (required)
     * @param analysisId The ID of the analysis (required)
     * @return AnalysisDetails
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AnalysisDetails getAnalysisDetails(Integer projectId, Integer analysisId) throws ApiException {
        ApiResponse<AnalysisDetails> resp = getAnalysisDetailsWithHttpInfo(projectId, analysisId);
        return resp.getData();
    }

    /**
     * Get Analysis Details
     * Obtain analysis details, such as start and finish times
     * @param projectId The ID of the project. (required)
     * @param analysisId The ID of the analysis (required)
     * @return ApiResponse&lt;AnalysisDetails&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AnalysisDetails> getAnalysisDetailsWithHttpInfo(Integer projectId, Integer analysisId) throws ApiException {
        com.squareup.okhttp.Call call = getAnalysisDetailsValidateBeforeCall(projectId, analysisId, null, null);
        Type localVarReturnType = new TypeToken<AnalysisDetails>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Analysis Details (asynchronously)
     * Obtain analysis details, such as start and finish times
     * @param projectId The ID of the project. (required)
     * @param analysisId The ID of the analysis (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAnalysisDetailsAsync(Integer projectId, Integer analysisId, final ApiCallback<AnalysisDetails> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAnalysisDetailsValidateBeforeCall(projectId, analysisId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnalysisDetails>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getInputMetadata
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getInputMetadataCall(String prepId, String inputId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/analysis-prep/{prep-id}/{input-id}"
            .replaceAll("\\{" + "prep-id" + "\\}", apiClient.escapeString(prepId.toString()))
            .replaceAll("\\{" + "input-id" + "\\}", apiClient.escapeString(inputId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getInputMetadataValidateBeforeCall(String prepId, String inputId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'prepId' is set
        if (prepId == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling getInputMetadata(Async)");
        }
        
        // verify the required parameter 'inputId' is set
        if (inputId == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling getInputMetadata(Async)");
        }
        

        com.squareup.okhttp.Call call = getInputMetadataCall(prepId, inputId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get Input Metadata
     * Get metadata for a particular input associated with an Analysis Prep. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @return InputDisplayInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InputDisplayInfo getInputMetadata(String prepId, String inputId) throws ApiException {
        ApiResponse<InputDisplayInfo> resp = getInputMetadataWithHttpInfo(prepId, inputId);
        return resp.getData();
    }

    /**
     * Get Input Metadata
     * Get metadata for a particular input associated with an Analysis Prep. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @return ApiResponse&lt;InputDisplayInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InputDisplayInfo> getInputMetadataWithHttpInfo(String prepId, String inputId) throws ApiException {
        com.squareup.okhttp.Call call = getInputMetadataValidateBeforeCall(prepId, inputId, null, null);
        Type localVarReturnType = new TypeToken<InputDisplayInfo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Input Metadata (asynchronously)
     * Get metadata for a particular input associated with an Analysis Prep. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getInputMetadataAsync(String prepId, String inputId, final ApiCallback<InputDisplayInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getInputMetadataValidateBeforeCall(prepId, inputId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InputDisplayInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for queryAnalysisPrepState
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryAnalysisPrepStateCall(String prepId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/analysis-prep/{prep-id}"
            .replaceAll("\\{" + "prep-id" + "\\}", apiClient.escapeString(prepId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryAnalysisPrepStateValidateBeforeCall(String prepId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'prepId' is set
        if (prepId == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling queryAnalysisPrepState(Async)");
        }
        

        com.squareup.okhttp.Call call = queryAnalysisPrepStateCall(prepId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Query Analysis Prep State
     * Get a list of Input IDs and Verification Errors for an Analysis Prep. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @return AnalysisQueryResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AnalysisQueryResponse queryAnalysisPrepState(String prepId) throws ApiException {
        ApiResponse<AnalysisQueryResponse> resp = queryAnalysisPrepStateWithHttpInfo(prepId);
        return resp.getData();
    }

    /**
     * Query Analysis Prep State
     * Get a list of Input IDs and Verification Errors for an Analysis Prep. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @return ApiResponse&lt;AnalysisQueryResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AnalysisQueryResponse> queryAnalysisPrepStateWithHttpInfo(String prepId) throws ApiException {
        com.squareup.okhttp.Call call = queryAnalysisPrepStateValidateBeforeCall(prepId, null, null);
        Type localVarReturnType = new TypeToken<AnalysisQueryResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Query Analysis Prep State (asynchronously)
     * Get a list of Input IDs and Verification Errors for an Analysis Prep. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryAnalysisPrepStateAsync(String prepId, final ApiCallback<AnalysisQueryResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = queryAnalysisPrepStateValidateBeforeCall(prepId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnalysisQueryResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for runPreparedAnalysis
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call runPreparedAnalysisCall(String prepId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/analysis-prep/{prep-id}/analyze"
            .replaceAll("\\{" + "prep-id" + "\\}", apiClient.escapeString(prepId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call runPreparedAnalysisValidateBeforeCall(String prepId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'prepId' is set
        if (prepId == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling runPreparedAnalysis(Async)");
        }
        

        com.squareup.okhttp.Call call = runPreparedAnalysisCall(prepId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Run Prepared Analysis
     * Once all of the verificationErrors in an Analysis Prep are addressed, an analysis can be started. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @return Analysis
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Analysis runPreparedAnalysis(String prepId) throws ApiException {
        ApiResponse<Analysis> resp = runPreparedAnalysisWithHttpInfo(prepId);
        return resp.getData();
    }

    /**
     * Run Prepared Analysis
     * Once all of the verificationErrors in an Analysis Prep are addressed, an analysis can be started. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @return ApiResponse&lt;Analysis&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Analysis> runPreparedAnalysisWithHttpInfo(String prepId) throws ApiException {
        com.squareup.okhttp.Call call = runPreparedAnalysisValidateBeforeCall(prepId, null, null);
        Type localVarReturnType = new TypeToken<Analysis>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Run Prepared Analysis (asynchronously)
     * Once all of the verificationErrors in an Analysis Prep are addressed, an analysis can be started. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call runPreparedAnalysisAsync(String prepId, final ApiCallback<Analysis> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = runPreparedAnalysisValidateBeforeCall(prepId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Analysis>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for setAnalysisName
     * @param projectId The ID of the project. (required)
     * @param analysisId The ID of the analysis (required)
     * @param analysisName An object containing the name of the analysis (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call setAnalysisNameCall(Integer projectId, Integer analysisId, AnalysisName analysisName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = analysisName;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/analyses/{analysis-id}"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()))
            .replaceAll("\\{" + "analysis-id" + "\\}", apiClient.escapeString(analysisId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call setAnalysisNameValidateBeforeCall(Integer projectId, Integer analysisId, AnalysisName analysisName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling setAnalysisName(Async)");
        }
        
        // verify the required parameter 'analysisId' is set
        if (analysisId == null) {
            throw new ApiException("Missing the required parameter 'analysisId' when calling setAnalysisName(Async)");
        }
        

        com.squareup.okhttp.Call call = setAnalysisNameCall(projectId, analysisId, analysisName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Name Analysis
     * Set a name for a specific analysis
     * @param projectId The ID of the project. (required)
     * @param analysisId The ID of the analysis (required)
     * @param analysisName An object containing the name of the analysis (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void setAnalysisName(Integer projectId, Integer analysisId, AnalysisName analysisName) throws ApiException {
        setAnalysisNameWithHttpInfo(projectId, analysisId, analysisName);
    }

    /**
     * Name Analysis
     * Set a name for a specific analysis
     * @param projectId The ID of the project. (required)
     * @param analysisId The ID of the analysis (required)
     * @param analysisName An object containing the name of the analysis (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> setAnalysisNameWithHttpInfo(Integer projectId, Integer analysisId, AnalysisName analysisName) throws ApiException {
        com.squareup.okhttp.Call call = setAnalysisNameValidateBeforeCall(projectId, analysisId, analysisName, null, null);
        return apiClient.execute(call);
    }

    /**
     * Name Analysis (asynchronously)
     * Set a name for a specific analysis
     * @param projectId The ID of the project. (required)
     * @param analysisId The ID of the analysis (required)
     * @param analysisName An object containing the name of the analysis (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call setAnalysisNameAsync(Integer projectId, Integer analysisId, AnalysisName analysisName, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = setAnalysisNameValidateBeforeCall(projectId, analysisId, analysisName, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for setDisplayTag
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @param tagId The ID of a Display Tag State object which would have been returned by the Get Input Metadata endpoint (required)
     * @param enabled A boolean indicating whether the tag should be enabled or disabled (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call setDisplayTagCall(String prepId, String inputId, String tagId, Enabled enabled, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = enabled;

        // create path and map variables
        String localVarPath = "/api/analysis-prep/{prep-id}/{input-id}/tag/{tag-id}"
            .replaceAll("\\{" + "prep-id" + "\\}", apiClient.escapeString(prepId.toString()))
            .replaceAll("\\{" + "input-id" + "\\}", apiClient.escapeString(inputId.toString()))
            .replaceAll("\\{" + "tag-id" + "\\}", apiClient.escapeString(tagId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call setDisplayTagValidateBeforeCall(String prepId, String inputId, String tagId, Enabled enabled, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'prepId' is set
        if (prepId == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling setDisplayTag(Async)");
        }
        
        // verify the required parameter 'inputId' is set
        if (inputId == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling setDisplayTag(Async)");
        }
        
        // verify the required parameter 'tagId' is set
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling setDisplayTag(Async)");
        }
        

        com.squareup.okhttp.Call call = setDisplayTagCall(prepId, inputId, tagId, enabled, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Enable/Disable Display Tag
     * Enable and disable individual display tags on individual prop inputs. Disabled tags will cause a file to be treated as if that tag were not there, for analysis purposes. For example, if the &#x60;{ \&quot;source\&quot;&amp;#58; \&quot;Java\&quot; } tag was disabled for a file when the analysis was started, that file would be treated as if there were no Java sources at all. This could mean that certain tools would not be run on that file. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @param tagId The ID of a Display Tag State object which would have been returned by the Get Input Metadata endpoint (required)
     * @param enabled A boolean indicating whether the tag should be enabled or disabled (optional)
     * @return InputDisplayInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InputDisplayInfo setDisplayTag(String prepId, String inputId, String tagId, Enabled enabled) throws ApiException {
        ApiResponse<InputDisplayInfo> resp = setDisplayTagWithHttpInfo(prepId, inputId, tagId, enabled);
        return resp.getData();
    }

    /**
     * Enable/Disable Display Tag
     * Enable and disable individual display tags on individual prop inputs. Disabled tags will cause a file to be treated as if that tag were not there, for analysis purposes. For example, if the &#x60;{ \&quot;source\&quot;&amp;#58; \&quot;Java\&quot; } tag was disabled for a file when the analysis was started, that file would be treated as if there were no Java sources at all. This could mean that certain tools would not be run on that file. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @param tagId The ID of a Display Tag State object which would have been returned by the Get Input Metadata endpoint (required)
     * @param enabled A boolean indicating whether the tag should be enabled or disabled (optional)
     * @return ApiResponse&lt;InputDisplayInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InputDisplayInfo> setDisplayTagWithHttpInfo(String prepId, String inputId, String tagId, Enabled enabled) throws ApiException {
        com.squareup.okhttp.Call call = setDisplayTagValidateBeforeCall(prepId, inputId, tagId, enabled, null, null);
        Type localVarReturnType = new TypeToken<InputDisplayInfo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Enable/Disable Display Tag (asynchronously)
     * Enable and disable individual display tags on individual prop inputs. Disabled tags will cause a file to be treated as if that tag were not there, for analysis purposes. For example, if the &#x60;{ \&quot;source\&quot;&amp;#58; \&quot;Java\&quot; } tag was disabled for a file when the analysis was started, that file would be treated as if there were no Java sources at all. This could mean that certain tools would not be run on that file. 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param inputId The ID of the prep input. (required)
     * @param tagId The ID of a Display Tag State object which would have been returned by the Get Input Metadata endpoint (required)
     * @param enabled A boolean indicating whether the tag should be enabled or disabled (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call setDisplayTagAsync(String prepId, String inputId, String tagId, Enabled enabled, final ApiCallback<InputDisplayInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = setDisplayTagValidateBeforeCall(prepId, inputId, tagId, enabled, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InputDisplayInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for uploadFile
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param file The file to be uploaded (required)
     * @param xClientRequestId Clients may choose an arbitrary identifier (a random string will suffice) to associate with the upload. This is done to enable deletion of an input before its file upload is fully complete. For more info, see Delete Input. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadFileCall(String prepId, File file, String xClientRequestId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/analysis-prep/{prep-id}/upload"
            .replaceAll("\\{" + "prep-id" + "\\}", apiClient.escapeString(prepId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xClientRequestId != null)
        localVarHeaderParams.put("X-Client-Request-Id", apiClient.parameterToString(xClientRequestId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadFileValidateBeforeCall(String prepId, File file, String xClientRequestId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'prepId' is set
        if (prepId == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling uploadFile(Async)");
        }
        
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadFile(Async)");
        }
        

        com.squareup.okhttp.Call call = uploadFileCall(prepId, file, xClientRequestId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Upload File to Analysis Prep
     * Analysis Preps should be populated by uploading files to Code Dx (or by configuring Git on a project, causing the source to be automatically added to the prep). 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param file The file to be uploaded (required)
     * @param xClientRequestId Clients may choose an arbitrary identifier (a random string will suffice) to associate with the upload. This is done to enable deletion of an input before its file upload is fully complete. For more info, see Delete Input. (optional)
     * @return FileUploadResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileUploadResponse uploadFile(String prepId, File file, String xClientRequestId) throws ApiException {
        ApiResponse<FileUploadResponse> resp = uploadFileWithHttpInfo(prepId, file, xClientRequestId);
        return resp.getData();
    }

    /**
     * Upload File to Analysis Prep
     * Analysis Preps should be populated by uploading files to Code Dx (or by configuring Git on a project, causing the source to be automatically added to the prep). 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param file The file to be uploaded (required)
     * @param xClientRequestId Clients may choose an arbitrary identifier (a random string will suffice) to associate with the upload. This is done to enable deletion of an input before its file upload is fully complete. For more info, see Delete Input. (optional)
     * @return ApiResponse&lt;FileUploadResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileUploadResponse> uploadFileWithHttpInfo(String prepId, File file, String xClientRequestId) throws ApiException {
        com.squareup.okhttp.Call call = uploadFileValidateBeforeCall(prepId, file, xClientRequestId, null, null);
        Type localVarReturnType = new TypeToken<FileUploadResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Upload File to Analysis Prep (asynchronously)
     * Analysis Preps should be populated by uploading files to Code Dx (or by configuring Git on a project, causing the source to be automatically added to the prep). 
     * @param prepId The ID of the Analysis Prep. This should come from the Create Analysis Prep response. (required)
     * @param file The file to be uploaded (required)
     * @param xClientRequestId Clients may choose an arbitrary identifier (a random string will suffice) to associate with the upload. This is done to enable deletion of an input before its file upload is fully complete. For more info, see Delete Input. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call uploadFileAsync(String prepId, File file, String xClientRequestId, final ApiCallback<FileUploadResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = uploadFileValidateBeforeCall(prepId, file, xClientRequestId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileUploadResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
