/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.URISyntaxException;

public class URI {
    static final String UNRESERVED_EXTRAS = "_-!.~'()*";
    static final String PUNCTUATION = ",;:$&+=";
    static final String RESERVED = ",;:$&+=?/[]@";
    static final char SCHEME_SEPARATOR = ':';
    static final char PORT_SEPARATOR = ':';
    static final char USERINFO_SEPARATOR = '@';
    static final char PATH_SEPARATOR = '/';
    static final String AUTHORITY_MARKER = "//";
    static final char QUOTE_MARKER = '%';
    static final char QUERY_MARKER = '?';
    static final char QUERY_SEPARATOR = '&';
    static final char PARAMETER_SEPARATOR = '=';
    static final char SOCKET_QUERY_SEPARATOR = ';';
    static final char FRAGMENT_SEPARATOR = '#';
    private char querySeparator;
    private boolean opaque;
    private boolean absolute;
    private String schemeSpecificPart;
    private String authority;
    private String userInfo;
    private String host;
    private String scheme;
    private String path;
    private String query;
    private String fragment;
    private int port;

    public URI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        this.init();
        this.setScheme(scheme);
        this.setAuthority(host, port, userInfo, true);
        this.setPath(path, true);
        this.setQuery(query, true);
        this.setFragment(fragment, true);
    }

    public URI(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        this.init();
        this.setScheme(scheme);
        this.setAuthority(authority, true);
        this.setPath(path, true);
        this.setQuery(query, true);
        this.setFragment(fragment, true);
    }

    public URI(String scheme, String ssp, String fragment) throws URISyntaxException {
        this.init();
        this.setScheme(scheme);
        this.setSchemeSpecificPart(ssp, true);
        this.setFragment(fragment, true);
    }

    public URI(String uriString) throws URISyntaxException {
        if (uriString == null) {
            throw new URISyntaxException(uriString, "Input is null");
        }
        this.init();
        this.parseURI(uriString);
    }

    void init() {
        this.absolute = true;
        this.querySeparator = (char)38;
        this.opaque = false;
        this.port = -1;
    }

    protected void setScheme(String scheme) throws URISyntaxException {
        this.scheme = scheme;
        if (this.scheme == null) {
            this.absolute = false;
        } else {
            if (!this.isValidScheme(scheme)) {
                throw new URISyntaxException(scheme, "Invalid scheme");
            }
            if (this.isSocketScheme(scheme)) {
                this.querySeparator = (char)59;
            }
        }
    }

    protected void setSchemeSpecificPart(String ssp, boolean encode) throws URISyntaxException {
        this.parseSchemeSpecificPart(ssp, true);
    }

    protected void setAuthority(String newAuthority, boolean encode) throws URISyntaxException {
    }

    protected void setQuery(String query, boolean encode) throws URISyntaxException {
    }

    protected void setPath(String path, boolean encode) throws URISyntaxException {
    }

    protected void setAuthority(String host, int port, String userInfo, boolean encode) throws URISyntaxException {
    }

    protected void setFragment(String fragment, boolean encode) {
    }

    protected String rebuildSchemeSpecificPart() {
        StringBuffer buffer = new StringBuffer();
        if (!(this.opaque || this.host == null && this.port == -1)) {
            buffer.append(AUTHORITY_MARKER);
            if (this.userInfo != null) {
                buffer.append(this.getRawUserInfo() + '@');
            }
            if (this.host != null) {
                buffer.append(this.getHost());
            }
            if (this.port != -1) {
                buffer.append(':');
                buffer.append(this.getPort());
            }
        }
        if (this.path != null) {
            buffer.append(this.getRawPath());
        }
        if (this.query != null) {
            if (this.querySeparator == ';') {
                buffer.append(this.querySeparator + this.getRawQuery().replace('&', ';'));
            } else {
                buffer.append('?' + this.getRawQuery());
            }
        }
        return buffer.toString();
    }

    public static URI create(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.toString());
        }
        return uri;
    }

    protected void parseURI(String uriString) throws URISyntaxException {
        String scheme;
        String s = uriString;
        int index = s.indexOf(35);
        if (index != -1) {
            this.setFragment(s.substring(index + 1), false);
            s = s.substring(0, index);
        }
        if ((index = s.indexOf(58)) != -1 && this.isValidScheme(scheme = s.substring(0, index))) {
            this.setScheme(scheme);
            s = s.substring(index + 1);
        }
        this.parseSchemeSpecificPart(s, false);
    }

    protected void parseSchemeSpecificPart(String ssp, boolean encode) throws URISyntaxException {
        if (ssp == null) {
            throw new URISyntaxException(ssp, "Invalid scheme specific part");
        }
        if (this.scheme != null && ssp.charAt(0) != '/') {
            this.opaque = true;
            this.schemeSpecificPart = ssp;
            return;
        }
        String s = ssp;
        int index = s.lastIndexOf(63);
        if (index != -1) {
            this.setQuery(s.substring(index + 1), encode);
            s = s.substring(0, index);
        } else if (this.getQuerySeparator() == ';' && (index = s.indexOf(59)) != -1) {
            this.setQuery(s.substring(index + 1).replace(';', '&'), encode);
            s = s.substring(0, index);
        }
        index = s.startsWith(AUTHORITY_MARKER) ? 2 : 0;
        index = s.indexOf(47, index);
        if (index != -1) {
            this.setPath(s.substring(index), encode);
            s = s.substring(0, index);
        }
        this.setAuthority(s, encode);
    }

    int parseIntOption(String key, String value) throws URISyntaxException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new URISyntaxException(value, "Invalid " + key + " value: " + value);
        }
    }

    boolean isSocketScheme(String scheme) {
        return false;
    }

    boolean isValidScheme(String scheme) {
        return true;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return null;
    }

    public String getRawPath() {
        return this.path;
    }

    public String getQuery() {
        return null;
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getFragment() {
        return null;
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getSchemeSpecificPart() {
        return null;
    }

    public String getRawSchemeSpecificPart() {
        if (this.schemeSpecificPart == null) {
            this.schemeSpecificPart = this.rebuildSchemeSpecificPart();
        }
        return this.schemeSpecificPart;
    }

    public String getAuthority() {
        return null;
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getUserInfo() {
        return null;
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    char getQuerySeparator() {
        return this.querySeparator;
    }

    public String toString() {
        return this.toASCIIString();
    }

    public String toASCIIString() {
        StringBuffer buffer = new StringBuffer();
        if (this.scheme != null) {
            buffer.append(this.scheme + ':');
        }
        buffer.append(this.getRawSchemeSpecificPart());
        if (this.fragment != null) {
            buffer.append('#' + this.getRawFragment());
        }
        return buffer.toString();
    }

    public URI relativize(URI uri) {
        if (this.isOpaque() || uri.isOpaque()) {
            return uri;
        }
        if (this.getScheme() == null || uri.getScheme() == null || !this.getScheme().equals(uri.getScheme())) {
            return uri;
        }
        String thisAuthority = null;
        String thatAuthority = null;
        String thisPath = null;
        String thatPath = null;
        thisAuthority = this.getAuthority();
        if (thisAuthority == null || (thatAuthority = uri.getAuthority()) == null || !thisAuthority.equals(thatAuthority)) {
            return uri;
        }
        thisPath = this.getPath();
        if (thisPath == null || (thatPath = uri.getPath()) == null || !thatPath.startsWith(thisPath + '/')) {
            return uri;
        }
        try {
            return new URI(null, null, thatPath.substring(thisPath.length() + 1), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public URI resolve(URI uri) {
        if (this.isOpaque() || uri.isAbsolute()) {
            return uri;
        }
        String thatPath = uri.getPath();
        String thatQuery = uri.getQuery();
        String thatAuthority = uri.getAuthority();
        String thatFragment = uri.getFragment();
        try {
            int index;
            if (thatFragment != null && uri.getScheme() == null && thatPath == null && thatQuery == null && thatAuthority == null) {
                return new URI(this.getScheme(), this.getAuthority(), this.getPath(), this.getQuery(), thatFragment);
            }
            if (thatAuthority != null) {
                return new URI(this.getScheme(), thatAuthority, thatPath, thatQuery, thatFragment);
            }
            if (thatPath != null && thatPath.charAt(0) == '/') {
                return new URI(this.getScheme(), this.getAuthority(), thatPath, thatQuery, thatFragment);
            }
            String thisPath = this.getPath();
            if (thisPath != null && (index = thisPath.lastIndexOf(47)) != -1) {
                thisPath = thisPath.substring(index);
            }
            thisPath = thisPath + '/' + thatPath;
            return new URI(this.getScheme(), this.getAuthority(), thisPath, thatQuery, thatFragment).normalize();
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use.getMessage());
        }
    }

    public URI normalize() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.schemeSpecificPart == null ? 0 : this.schemeSpecificPart.hashCode());
        return result;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        URI other = (URI)that;
        if (this.fragment == null ? other.fragment != null : !this.getFragment().equals(other.getFragment())) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.schemeSpecificPart == null ? other.schemeSpecificPart != null : !this.getSchemeSpecificPart().equals(other.getSchemeSpecificPart()));
    }
}

