/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.util.Hashtable;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatSymbols
implements Cloneable {
    public static final int ZONE_ID = 0;
    public static final int ZONE_LONGNAME = 1;
    public static final int ZONE_SHORTNAME = 2;
    public static final int ZONE_LONGNAME_DST = 3;
    public static final int ZONE_SHORTNAME_DST = 4;
    private static final String L10N_ZONE_LONGNAME = "ZONE_LONGNAME_";
    private static final String L10N_ZONE_SHORTNAME = "ZONE_SHORTNAME_";
    private static final String L10N_ZONE_LONGNAME_DST = "ZONE_LONGNAME_DST_";
    private static final String L10N_ZONE_SHORTNAME_DST = "ZONE_SHORTNAME_DST_";
    private static final String L10N_WEEKDAY_LONGNAME = "WEEKDAY_LONGNAME_";
    private static final String L10N_WEEKDAY_SHORTNAME = "WEEKDAY_SHORTNAME_";
    private static final String L10N_MONTH_LONGNAME = "MONTH_LONGNAME_";
    private static final String L10N_MONTH_SHORTNAME = "MONTH_SHORTNAME_";
    private static final String L10N_AMPM = "AMPM_";
    private static final String L10N_ERA = "ERA_";
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] WEEKDAYS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] AMPMS = new String[]{"AM", "PM"};
    private static final String[] ERAS = new String[]{"AD", "BC"};
    private Hashtable<String, String> resourceBundle;
    private String[] ampms;
    private String[] months;
    private String[][] zoneStrings;
    private String[] shortMonths;
    private String[] weekdays;
    private String[] shortWeekdays;
    private String[] eras;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAmPmStrings() {
        DateFormatSymbols dateFormatSymbols = this;
        synchronized (dateFormatSymbols) {
            if (this.ampms == null) {
                if (this.resourceBundle == null) {
                    return AMPMS;
                }
                String[] newAmpms = new String[]{this.getLocalizedValue("AMPM_AM", AMPMS[0]), this.getLocalizedValue("AMPM_PM", AMPMS[1])};
                this.ampms = newAmpms;
            }
        }
        return this.ampms;
    }

    public void setAmPmStrings(String[] newAmpms) {
        if (newAmpms.length != 2) {
            throw new IllegalArgumentException("Expecting array size of 2");
        }
        this.ampms = newAmpms;
    }

    public Hashtable<String, String> getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(Hashtable<String, String> newResourceBundle) {
        this.resourceBundle = newResourceBundle;
        this.ampms = null;
        this.months = null;
        this.zoneStrings = null;
        this.shortMonths = null;
        this.weekdays = null;
        this.shortWeekdays = null;
        this.eras = null;
    }

    String getLocalizedValue(String key, String defaultValue) {
        Hashtable<String, String> resourceBundle = this.getResourceBundle();
        if (resourceBundle == null || !resourceBundle.containsKey(key)) {
            return defaultValue;
        }
        String v = resourceBundle.get(key);
        return v.length() > 0 ? v : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getZoneStrings() {
        DateFormatSymbols dateFormatSymbols = this;
        synchronized (dateFormatSymbols) {
            if (this.zoneStrings == null) {
                String[] ids = TimeZone.getAvailableIDs();
                String[][] newZoneStrings = new String[ids.length][5];
                for (int i = 0; i < ids.length; ++i) {
                    newZoneStrings[i][0] = ids[i];
                    String key = ids[i].toUpperCase();
                    newZoneStrings[i][1] = this.getLocalizedValue(L10N_ZONE_LONGNAME + key, ids[i]);
                    newZoneStrings[i][2] = this.getLocalizedValue(L10N_ZONE_SHORTNAME + key, ids[i]);
                    newZoneStrings[i][3] = this.getLocalizedValue(L10N_ZONE_LONGNAME_DST + key, ids[i]);
                    newZoneStrings[i][4] = this.getLocalizedValue(L10N_ZONE_SHORTNAME_DST + key, ids[i]);
                }
                this.zoneStrings = newZoneStrings;
            }
        }
        return this.zoneStrings;
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        if (newZoneStrings != null) {
            for (String[] zone : newZoneStrings) {
                if (zone.length >= 5) continue;
                throw new IllegalArgumentException("Expecting inner array size of 5");
            }
        }
        this.zoneStrings = newZoneStrings;
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        if (newShortWeekdays.length != 7) {
            throw new IllegalArgumentException("Expecting array size of 7");
        }
        this.shortWeekdays = newShortWeekdays;
    }

    String[] createShortforms(String[] longForms, String l10nKey) {
        String[] shortForms = new String[longForms.length];
        for (int i = 0; i < shortForms.length; ++i) {
            int len;
            String shortForm = this.getLocalizedValue(l10nKey + longForms[i].toUpperCase(), null);
            shortForms[i] = shortForm != null ? shortForm : ((len = longForms[i].length()) < 3 ? longForms[i] : longForms[i].substring(0, 3));
        }
        return shortForms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getShortWeekdays() {
        DateFormatSymbols dateFormatSymbols = this;
        synchronized (dateFormatSymbols) {
            if (this.shortWeekdays == null) {
                this.shortWeekdays = this.createShortforms(this.getWeekdays(), L10N_WEEKDAY_SHORTNAME);
            }
        }
        return this.shortWeekdays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getWeekdays() {
        DateFormatSymbols dateFormatSymbols = this;
        synchronized (dateFormatSymbols) {
            if (this.weekdays == null) {
                if (this.resourceBundle == null) {
                    return WEEKDAYS;
                }
                String[] newWeekdays = new String[WEEKDAYS.length];
                for (int i = 0; i < WEEKDAYS.length; ++i) {
                    String key = WEEKDAYS[i].toUpperCase();
                    newWeekdays[i] = this.getLocalizedValue(L10N_WEEKDAY_LONGNAME + key, WEEKDAYS[i]);
                }
                this.weekdays = newWeekdays;
            }
        }
        return this.weekdays;
    }

    public void setWeekdays(String[] newWeekdays) {
        if (newWeekdays != null && newWeekdays.length != 7) {
            throw new IllegalArgumentException("Expecting array size of 7");
        }
        this.weekdays = newWeekdays;
    }

    public void setShortMonths(String[] newShortMonths) {
        if (newShortMonths != null && newShortMonths.length != 12) {
            throw new IllegalArgumentException("Expecting array size of 12");
        }
        this.shortMonths = newShortMonths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getShortMonths() {
        DateFormatSymbols dateFormatSymbols = this;
        synchronized (dateFormatSymbols) {
            if (this.shortMonths == null) {
                this.shortMonths = this.createShortforms(MONTHS, L10N_MONTH_SHORTNAME);
            }
        }
        return this.shortMonths;
    }

    public void setMonths(String[] newMonths) {
        if (newMonths != null && newMonths.length != 12) {
            throw new IllegalArgumentException("Expecting array size of 12");
        }
        this.months = newMonths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMonths() {
        DateFormatSymbols dateFormatSymbols = this;
        synchronized (dateFormatSymbols) {
            if (this.months == null) {
                if (this.resourceBundle == null) {
                    return MONTHS;
                }
                String[] newMonths = new String[MONTHS.length];
                for (int i = 0; i < MONTHS.length; ++i) {
                    String key = MONTHS[i].toUpperCase();
                    newMonths[i] = this.getLocalizedValue(L10N_MONTH_LONGNAME + key, MONTHS[i]);
                }
                this.months = newMonths;
            }
        }
        return this.months;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEras() {
        DateFormatSymbols dateFormatSymbols = this;
        synchronized (dateFormatSymbols) {
            if (this.eras == null) {
                if (this.resourceBundle == null) {
                    return ERAS;
                }
                String[] newEras = new String[]{this.getLocalizedValue("ERA_BC", ERAS[0]), this.getLocalizedValue("ERA_AD", ERAS[1])};
                this.eras = newEras;
            }
        }
        return this.eras;
    }

    public void setEras(String[] newEras) {
        this.eras = newEras;
    }

    public Object clone() {
        DateFormatSymbols dfs = new DateFormatSymbols();
        dfs.ampms = this.ampms;
        dfs.eras = this.eras;
        dfs.months = this.months;
        dfs.shortMonths = this.shortMonths;
        dfs.shortWeekdays = this.shortWeekdays;
        dfs.weekdays = this.weekdays;
        dfs.zoneStrings = this.zoneStrings;
        dfs.resourceBundle = this.resourceBundle;
        return dfs;
    }
}

