/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    protected AbstractList() {
    }

    @Override
    public void add(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E object) {
        this.add(this.size(), object);
        return true;
    }

    @Override
    public boolean addAll(int location, Collection<? extends E> collection) {
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            this.add(location++, it.next());
        }
        return !collection.isEmpty();
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() != this.size()) {
                return false;
            }
            Iterator<E> it1 = this.iterator();
            Iterator it2 = list.iterator();
            while (it1.hasNext()) {
                E e1 = it1.next();
                Object e2 = it2.next();
                if (e1 != null ? e1.equals(e2) : e2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public int hashCode() {
        int result = 1;
        for (E object : this) {
            result = 31 * result + (object == null ? 0 : object.hashCode());
        }
        return result;
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<E> it = this.listIterator();
        if (object != null) {
            while (it.hasNext()) {
                if (!object.equals(it.next())) continue;
                return it.previousIndex();
            }
        } else {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return it.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new SimpleListIterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<E> it = this.listIterator(this.size());
        if (object != null) {
            while (it.hasPrevious()) {
                if (!object.equals(it.previous())) continue;
                return it.nextIndex();
            }
        } else {
            while (it.hasPrevious()) {
                if (it.previous() != null) continue;
                return it.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        return new FullListIterator(location);
    }

    @Override
    public E remove(int location) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int start, int end) {
        ListIterator<E> it = this.listIterator(start);
        for (int i = start; i < end; ++i) {
            it.next();
            it.remove();
        }
    }

    @Override
    public E set(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int start, int end) {
        if (0 <= start && end <= this.size()) {
            if (start <= end) {
                if (this instanceof RandomAccess) {
                    return new SubAbstractListRandomAccess(this, start, end);
                }
                return new SubAbstractList(this, start, end);
            }
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int iter = 0; iter < result.length; ++iter) {
            result[iter] = this.get(iter);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        Object[] arr = contents;
        if (this.size() > arr.length) {
            arr = new Object[this.size()];
        }
        for (int iter = 0; iter < arr.length; ++iter) {
            arr[iter] = this.get(iter);
        }
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubAbstractList<E>
    extends AbstractList<E> {
        private final AbstractList<E> fullList;
        private int offset;
        private int size;

        SubAbstractList(AbstractList<E> list, int start, int end) {
            this.fullList = list;
            this.modCount = this.fullList.modCount;
            this.offset = start;
            this.size = end - start;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void add(int location, E object) {
            if (this.modCount != this.fullList.modCount) throw new ConcurrentModificationException();
            if (0 > location || location > this.size) throw new IndexOutOfBoundsException();
            this.fullList.add(location + this.offset, object);
            ++this.size;
            this.modCount = this.fullList.modCount;
        }

        @Override
        public boolean addAll(int location, Collection<? extends E> collection) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location <= this.size) {
                    boolean result = this.fullList.addAll(location + this.offset, collection);
                    if (result) {
                        this.size += collection.size();
                        this.modCount = this.fullList.modCount;
                    }
                    return result;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            if (this.modCount == this.fullList.modCount) {
                boolean result = this.fullList.addAll(this.offset + this.size, collection);
                if (result) {
                    this.size += collection.size();
                    this.modCount = this.fullList.modCount;
                }
                return result;
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public E get(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location < this.size) {
                    return this.fullList.get(location + this.offset);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location <= this.size) {
                    return new SubAbstractListIterator<E>(this.fullList.listIterator(location + this.offset), this, this.offset, this.size);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public E remove(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location < this.size) {
                    E result = this.fullList.remove(location + this.offset);
                    --this.size;
                    this.modCount = this.fullList.modCount;
                    return result;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        protected void removeRange(int start, int end) {
            if (start != end) {
                if (this.modCount == this.fullList.modCount) {
                    this.fullList.removeRange(start + this.offset, end + this.offset);
                    this.size -= end - start;
                    this.modCount = this.fullList.modCount;
                } else {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public E set(int location, E object) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location < this.size) {
                    return this.fullList.set(location + this.offset, object);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int size() {
            if (this.modCount == this.fullList.modCount) {
                return this.size;
            }
            throw new ConcurrentModificationException();
        }

        void sizeChanged(boolean increment) {
            this.size = increment ? ++this.size : --this.size;
            this.modCount = this.fullList.modCount;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class SubAbstractListIterator<E>
        implements ListIterator<E> {
            private final SubAbstractList<E> subList;
            private final ListIterator<E> iterator;
            private int start;
            private int end;

            SubAbstractListIterator(ListIterator<E> it, SubAbstractList<E> list, int offset, int length) {
                this.iterator = it;
                this.subList = list;
                this.start = offset;
                this.end = this.start + length;
            }

            @Override
            public void add(E object) {
                this.iterator.add(object);
                this.subList.sizeChanged(true);
                ++this.end;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.nextIndex() < this.end;
            }

            @Override
            public boolean hasPrevious() {
                return this.iterator.previousIndex() >= this.start;
            }

            @Override
            public E next() {
                if (this.iterator.nextIndex() < this.end) {
                    return this.iterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.iterator.nextIndex() - this.start;
            }

            @Override
            public E previous() {
                if (this.iterator.previousIndex() >= this.start) {
                    return this.iterator.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int previousIndex() {
                int previous = this.iterator.previousIndex();
                if (previous >= this.start) {
                    return previous - this.start;
                }
                return -1;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                this.subList.sizeChanged(false);
                --this.end;
            }

            @Override
            public void set(E object) {
                this.iterator.set(object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubAbstractListRandomAccess<E>
    extends SubAbstractList<E>
    implements RandomAccess {
        SubAbstractListRandomAccess(AbstractList<E> list, int start, int end) {
            super(list, start, end);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FullListIterator
    extends SimpleListIterator
    implements ListIterator<E> {
        FullListIterator(int start) {
            if (start < 0 || start > this.numLeft) {
                throw new IndexOutOfBoundsException();
            }
            this.numLeft -= start;
        }

        @Override
        public void add(E object) {
            if (this.expectedModCount != AbstractList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                AbstractList.this.add(AbstractList.this.size() - this.numLeft, object);
                this.expectedModCount = AbstractList.this.modCount;
                this.lastPosition = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.numLeft < AbstractList.this.size();
        }

        @Override
        public int nextIndex() {
            return AbstractList.this.size() - this.numLeft;
        }

        @Override
        public E previous() {
            if (this.expectedModCount != AbstractList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                int index = AbstractList.this.size() - this.numLeft - 1;
                Object result = AbstractList.this.get(index);
                ++this.numLeft;
                this.lastPosition = index;
                return result;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return AbstractList.this.size() - this.numLeft - 1;
        }

        @Override
        public void set(E object) {
            if (this.expectedModCount != AbstractList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                AbstractList.this.set(this.lastPosition, object);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleListIterator
    implements Iterator<E> {
        int numLeft;
        int expectedModCount;
        int lastPosition;

        private SimpleListIterator() {
            this.numLeft = AbstractList.this.size();
            this.expectedModCount = AbstractList.this.modCount;
            this.lastPosition = -1;
        }

        @Override
        public boolean hasNext() {
            return this.numLeft > 0;
        }

        @Override
        public E next() {
            if (this.expectedModCount != AbstractList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                int index = AbstractList.this.size() - this.numLeft;
                Object result = AbstractList.this.get(index);
                this.lastPosition = index;
                --this.numLeft;
                return result;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastPosition == -1) {
                throw new IllegalStateException();
            }
            if (this.expectedModCount != AbstractList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                if (this.lastPosition == AbstractList.this.size() - this.numLeft) {
                    --this.numLeft;
                }
                AbstractList.this.remove(this.lastPosition);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = AbstractList.this.modCount;
            this.lastPosition = -1;
        }
    }
}

