/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HashSet<E>
extends AbstractSet<E>
implements Set<E> {
    transient HashMap<E, HashSet<E>> backingMap;

    public HashSet() {
        this(new HashMap());
    }

    public HashSet(int capacity) {
        this(new HashMap(capacity));
    }

    public HashSet(int capacity, float loadFactor) {
        this(new HashMap(capacity, loadFactor));
    }

    public HashSet(Collection<? extends E> collection) {
        this(new HashMap(collection.size() < 6 ? 11 : collection.size() * 2));
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    HashSet(HashMap<E, HashSet<E>> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public boolean add(E object) {
        return this.backingMap.put(object, this) == null;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    HashMap<E, HashSet<E>> createBackingMap(int capacity, float loadFactor) {
        return new HashMap(capacity, loadFactor);
    }
}

