/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.redis.autoconfigure;

import com.alibaba.fastjson2.JSONFactory;
import com.codeupsoft.component.redis.autoconfigure.FastJson2RedisSerializer;
import com.codeupsoft.component.redis.client.RedisTemplateClient;
import com.codeupsoft.component.redis.properties.ComponentRedisProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@EnableConfigurationProperties(value={ComponentRedisProperties.class})
@ConditionalOnProperty(prefix="codeupsoft.component.redis", name={"auto-configure"}, havingValue="true")
public class ComponentRedisAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentRedisAutoConfiguration.class);
    private final ComponentRedisProperties componentRedisProperties;

    @Bean
    @ConditionalOnMissingBean(value={RedisTemplate.class})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        List<String> autoTypeAccept = this.componentRedisProperties.getAutoTypeAccept();
        log.info("FastJson autoTypeAccept: {}", autoTypeAccept);
        for (String accept : autoTypeAccept) {
            JSONFactory.getDefaultObjectReaderProvider().addAutoTypeAccept(accept);
        }
        FastJson2RedisSerializer<Object> fastJson2RedisSerializer = new FastJson2RedisSerializer<Object>(Object.class);
        template.setDefaultSerializer(fastJson2RedisSerializer);
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringSerializer);
        template.setHashKeySerializer((RedisSerializer)stringSerializer);
        template.setValueSerializer(fastJson2RedisSerializer);
        template.setHashValueSerializer(fastJson2RedisSerializer);
        template.setEnableTransactionSupport(true);
        template.afterPropertiesSet();
        log.info("RedisTemplate\u914d\u7f6e\u5b8c\u6210, \u4f7f\u7528\u5e8f\u5217\u5316\u5668: {}", (Object)"FastJson2RedisTemplate");
        return template;
    }

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    public RedisTemplateClient redisTemplateClient(RedisTemplate<String, Object> redisTemplate) {
        return new RedisTemplateClient(this.componentRedisProperties, redisTemplate);
    }

    @Generated
    public ComponentRedisAutoConfiguration(ComponentRedisProperties componentRedisProperties) {
        this.componentRedisProperties = componentRedisProperties;
    }
}

