/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.redis.autoconfigure;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class FastJson2RedisSerializer<T>
implements RedisSerializer<T> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Class<T> clazz;

    public FastJson2RedisSerializer(Class<T> clazz) {
        this.clazz = clazz;
    }

    public byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return new byte[0];
        }
        try {
            return JSON.toJSONString(t, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName, JSONWriter.Feature.FieldBased, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.ReferenceDetection, JSONWriter.Feature.WriteEnumsUsingName}).getBytes(DEFAULT_CHARSET);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public T deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        String str = new String(bytes, DEFAULT_CHARSET);
        try {
            return (T)JSON.parseObject((String)str, this.clazz, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType, JSONReader.Feature.FieldBased, JSONReader.Feature.UseNativeObject, JSONReader.Feature.AllowUnQuotedFieldNames});
        }
        catch (Exception ex) {
            throw new SerializationException("Could not deserialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    static {
        JSONFactory.createWriteContext();
    }
}

