/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.redis.client;

import com.codeupsoft.component.redis.client.RedisCacheData;
import com.codeupsoft.component.redis.client.RedisLoadWithLock;
import com.codeupsoft.component.redis.exception.RedisTryLockTimoOutException;
import com.codeupsoft.component.redis.function.RedisCacheLoader;
import com.codeupsoft.component.redis.function.RedisLockHolderNext;
import com.codeupsoft.component.redis.properties.ComponentRedisProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisTemplateClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisTemplateClient.class);
    private static final String UNLOCK_SCRIPT = "    local lockKey = KEYS[1]\n    local lockValue = ARGV[1]\n    local result = redis.call('GET', lockKey)\n    if result == lockValue then\n      redis.call('DEL', lockKey)\n      return 1\n    else\n      return 0\n    end\n";
    private final ComponentRedisProperties componentRedisProperties;
    private final RedisTemplate<String, Object> redisTemplate;
    private final RedisScript<Long> unlockScript = new DefaultRedisScript("    local lockKey = KEYS[1]\n    local lockValue = ARGV[1]\n    local result = redis.call('GET', lockKey)\n    if result == lockValue then\n      redis.call('DEL', lockKey)\n      return 1\n    else\n      return 0\n    end\n", Long.class);

    public boolean expire(String key, long timeout, TimeUnit timeUnit) {
        return this.redisTemplate.expire((Object)key, timeout, timeUnit);
    }

    public long getExpire(String key, TimeUnit timeUnit) {
        Long expire = this.redisTemplate.getExpire((Object)key, timeUnit);
        return expire != null ? expire : -1L;
    }

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public <T> void setCacheObject(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public <T> void setCacheObject(String key, T value, long timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout, timeUnit);
    }

    public <T> T getCacheObject(String key) {
        Object value = this.redisTemplate.opsForValue().get((Object)key);
        if (value == null) {
            return null;
        }
        try {
            Object result = value;
            return (T)result;
        }
        catch (ClassCastException e) {
            log.error("Redis\u7f13\u5b58\u5bf9\u8c61\u7c7b\u578b\u8f6c\u6362\u5931\u8d25: {}, class:{} ", (Object)key, (Object)value.getClass().getName());
            return null;
        }
    }

    public <T> T getCacheObjectOrLoad(String key, RedisCacheLoader<T> redisCacheLoader) {
        T o = this.getCacheObject(key);
        if (Objects.isNull(o)) {
            RedisCacheData<T> load = redisCacheLoader.load();
            if (Objects.isNull(load.value())) {
                return null;
            }
            this.redisTemplate.opsForValue().set((Object)key, load.value(), load.expire(), load.timeUnit());
            o = load.value();
        }
        return o;
    }

    public <T> T getCacheObjectOrLoadWithLock(String key, RedisLoadWithLock<T> redisLoadWithLock) {
        Object o = this.getCacheObject(key);
        if (Objects.isNull(o)) {
            AtomicReference reference = new AtomicReference();
            this.tryLockWhile(key, redisLoadWithLock, () -> {
                Object value = this.getCacheObject(key);
                if (Objects.nonNull(value)) {
                    reference.set(value);
                    return;
                }
                RedisCacheData data = redisLoadWithLock.cacheData().load();
                Object result = data.value();
                if (Objects.isNull(result)) {
                    return;
                }
                reference.set(result);
                this.redisTemplate.opsForValue().set((Object)key, result, data.expire(), data.timeUnit());
            });
            o = reference.get();
        }
        return o;
    }

    public boolean deleteObject(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.delete((Object)key));
    }

    public long deleteObject(Collection<String> keys) {
        Long count = this.redisTemplate.delete(keys);
        return count != null ? count : 0L;
    }

    public <T> long setCacheList(String key, List<T> dataList) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, new Object[]{dataList});
        return count != null ? count : 0L;
    }

    public <T> void setCacheList(String key, List<T> dataList, long timeout, TimeUnit timeUnit) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, new Object[]{dataList});
        this.expire(key, timeout, timeUnit);
    }

    public <T> List<T> getCacheList(String key) {
        return this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }

    public <T> List<T> getCacheListOrLoad(String key, RedisCacheLoader<List<T>> redisCacheLoader) {
        List<T> list = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        if (list == null || list.isEmpty()) {
            RedisCacheData<List<T>> load = redisCacheLoader.load();
            if (Objects.isNull(load.value())) {
                return Collections.emptyList();
            }
            this.setCacheList(key, load.value(), load.expire(), load.timeUnit());
            list = load.value();
        }
        return list;
    }

    public <T> List<T> getCacheListOrLoadWithLock(String key, RedisLoadWithLock<List<T>> redisLoadWithLock) {
        List list = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        if (list == null || list.isEmpty()) {
            AtomicReference reference = new AtomicReference();
            this.tryLockWhile(key, redisLoadWithLock, () -> {
                List value = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
                if (Objects.nonNull(value) && !value.isEmpty()) {
                    reference.set(value);
                    return;
                }
                RedisCacheData data = redisLoadWithLock.cacheData().load();
                List result = (List)data.value();
                if (Objects.isNull(result)) {
                    return;
                }
                reference.set(result);
                this.setCacheList(key, result, data.expire(), data.timeUnit());
            });
            list = (List)reference.get();
        }
        return list;
    }

    public <T> long leftPushList(String key, T value) {
        Long count = this.redisTemplate.opsForList().leftPush((Object)key, value);
        return count != null ? count : 0L;
    }

    public <T> long rightPushList(String key, T value) {
        Long count = this.redisTemplate.opsForList().rightPush((Object)key, value);
        return count != null ? count : 0L;
    }

    public <T> T leftPopList(String key) {
        return (T)this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public <T> T rightPopList(String key) {
        return (T)this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public long getListSize(String key) {
        Long size = this.redisTemplate.opsForList().size((Object)key);
        return size != null ? size : 0L;
    }

    public <T> T getListIndex(String key, long index) {
        return (T)this.redisTemplate.opsForList().index((Object)key, index);
    }

    @SafeVarargs
    public final <T> long setCacheSet(String key, T ... values) {
        Long count = this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
        return count != null ? count : 0L;
    }

    @SafeVarargs
    public final <T> long setCacheSet(String key, long timeout, TimeUnit timeUnit, T ... values) {
        Long count = this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
        this.expire(key, timeout, timeUnit);
        return count != null ? count : 0L;
    }

    public <T> Collection<T> getCacheSet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public <T> boolean isMemberOfSet(String key, T value) {
        return Boolean.TRUE.equals(this.redisTemplate.opsForSet().isMember((Object)key, value));
    }

    public long getSetSize(String key) {
        Long size = this.redisTemplate.opsForSet().size((Object)key);
        return size != null ? size : 0L;
    }

    @SafeVarargs
    public final <T> long removeSet(String key, T ... values) {
        Long count = this.redisTemplate.opsForSet().remove((Object)key, (Object[])values);
        return count != null ? count : 0L;
    }

    public <T> T randomMemberOfSet(String key) {
        return (T)this.redisTemplate.opsForSet().randomMember((Object)key);
    }

    public <K, V> void setCacheMap(String key, Map<K, V> dataMap) {
        this.redisTemplate.opsForHash().putAll((Object)key, dataMap);
    }

    public <K, V> void setCacheMap(String key, Map<K, V> dataMap, long timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForHash().putAll((Object)key, dataMap);
        this.expire(key, timeout, timeUnit);
    }

    public <K, V> void putCacheMapValue(String key, K hashKey, V value) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, value);
    }

    public <K, V> Map<K, V> getCacheMap(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public <K, V> Map<K, V> getCacheMapOrLoad(String key, RedisCacheLoader<Map<K, V>> cacheLoader) {
        Map<K, V> entries = this.redisTemplate.opsForHash().entries((Object)key);
        if (entries == null || entries.isEmpty()) {
            RedisCacheData<Map<K, V>> load = cacheLoader.load();
            if (Objects.isNull(load.value())) {
                return null;
            }
            this.setCacheMap(key, load.value(), load.expire(), load.timeUnit());
            entries = load.value();
        }
        return entries;
    }

    public <K, V> Map<K, V> getCacheMapOrLoadWithLock(String key, RedisLoadWithLock<Map<K, V>> redisLoadWithLock) {
        Map entries = this.redisTemplate.opsForHash().entries((Object)key);
        if (entries == null || entries.isEmpty()) {
            AtomicReference reference = new AtomicReference();
            this.tryLockWhile(key, redisLoadWithLock, () -> {
                Map value = this.redisTemplate.opsForHash().entries((Object)key);
                if (Objects.nonNull(value) && !value.isEmpty()) {
                    reference.set(value);
                    return;
                }
                RedisCacheData data = redisLoadWithLock.cacheData().load();
                Map result = (Map)data.value();
                if (Objects.isNull(result)) {
                    return;
                }
                reference.set(result);
                this.setCacheMap(key, result, data.expire(), data.timeUnit());
            });
            entries = (Map)reference.get();
        }
        return entries;
    }

    public <K, V> V getCacheMapValue(String key, K hashKey) {
        return (V)this.redisTemplate.opsForHash().get((Object)key, hashKey);
    }

    public <K, V> List<V> getMultiCacheMapValue(String key, Collection<K> hashKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hashKeys);
    }

    public <K> boolean hasMapKey(String key, K hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, hashKey);
    }

    public long getMapSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    @SafeVarargs
    public final <K> long deleteCacheMapValue(String key, K ... hashKeys) {
        return this.redisTemplate.opsForHash().delete((Object)key, (Object[])hashKeys);
    }

    public long increment(String key) {
        return this.increment(key, 1L);
    }

    public long increment(String key, long delta) {
        Long result = this.redisTemplate.opsForValue().increment((Object)key, delta);
        return result != null ? result : 0L;
    }

    public double increment(String key, double delta) {
        Double result = this.redisTemplate.opsForValue().increment((Object)key, delta);
        return result != null ? result : 0.0;
    }

    public long decrement(String key) {
        return this.decrement(key, 1L);
    }

    public long decrement(String key, long delta) {
        Long result = this.redisTemplate.opsForValue().decrement((Object)key, delta);
        return result != null ? result : 0L;
    }

    public <K> long incrementMapValue(String key, K hashKey, long delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, hashKey, delta);
    }

    public <K> double incrementMapValue(String key, K hashKey, double delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, hashKey, delta);
    }

    private boolean tryLock(String lockKey, String lockValue, long expireTime) {
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)lockValue, expireTime, TimeUnit.MILLISECONDS);
        return result != null && result != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void tryLockWhile(String key, RedisLoadWithLock<T> redisLoadWithLock, RedisLockHolderNext redisLockHolderNext) {
        String lockKey = this.componentRedisProperties.getLockKeyPrefix() + key;
        long waitExpireTime = System.currentTimeMillis() + this.componentRedisProperties.getLockTimeout();
        String lockValue = String.valueOf(System.currentTimeMillis());
        long expireTime = this.componentRedisProperties.getLockTimeout();
        if (Objects.nonNull(redisLoadWithLock.lockerExpire())) {
            expireTime = redisLoadWithLock.lockerExpire();
        }
        while (System.currentTimeMillis() < waitExpireTime) {
            if (!this.tryLock(lockKey, lockValue, expireTime)) continue;
            try {
                redisLockHolderNext.apply();
                return;
            }
            finally {
                this.releaseLock(lockKey, lockValue);
            }
        }
        throw new RedisTryLockTimoOutException(lockKey);
    }

    private void releaseLock(String lockKey, String lockValue) {
        this.redisTemplate.execute(this.unlockScript, Collections.singletonList(lockKey), new Object[]{lockValue});
    }

    @Generated
    public RedisTemplateClient(ComponentRedisProperties componentRedisProperties, RedisTemplate<String, Object> redisTemplate) {
        this.componentRedisProperties = componentRedisProperties;
        this.redisTemplate = redisTemplate;
    }
}

