/*
 * Decompiled with CFR 0.152.
 */
package com.codevasp.lazysodium.interfaces;

import com.codevasp.lazysodium.exceptions.SodiumException;
import com.codevasp.lazysodium.utils.DetachedEncrypt;
import com.codevasp.lazysodium.utils.Key;

public interface SecretBox {
    public static final int XSALSA20POLY1305_KEYBYTES = 32;
    public static final int XSALSA20POLY1305_NONCEBYTES = 24;
    public static final int XSALSA20POLY1305_MACBYTES = 16;
    public static final int KEYBYTES = 32;
    public static final int MACBYTES = 16;
    public static final int NONCEBYTES = 24;

    public static interface Lazy {
        public Key cryptoSecretBoxKeygen();

        public String cryptoSecretBoxEasy(String var1, byte[] var2, Key var3) throws SodiumException;

        public String cryptoSecretBoxOpenEasy(String var1, byte[] var2, Key var3) throws SodiumException;

        public DetachedEncrypt cryptoSecretBoxDetached(String var1, byte[] var2, Key var3) throws SodiumException;

        public String cryptoSecretBoxOpenDetached(DetachedEncrypt var1, byte[] var2, Key var3) throws SodiumException;
    }

    public static interface Native {
        public void cryptoSecretBoxKeygen(byte[] var1);

        public boolean cryptoSecretBoxEasy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public boolean cryptoSecretBoxOpenEasy(byte[] var1, byte[] var2, long var3, byte[] var5, byte[] var6);

        public boolean cryptoSecretBoxDetached(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7);

        public boolean cryptoSecretBoxOpenDetached(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6, byte[] var7);
    }
}

