/*
 * Decompiled with CFR 0.152.
 */
package com.codevasp.lazysodium.interfaces;

import com.codevasp.lazysodium.exceptions.SodiumException;
import com.codevasp.lazysodium.utils.BaseChecker;
import com.codevasp.lazysodium.utils.Key;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public interface SecretStream {
    public static final int CHACHA20_IETF_NONCEBYTES = 12;
    public static final int KEYBYTES = 32;
    public static final int ABYTES = 17;
    public static final int HEADERBYTES = 24;
    public static final int NONCEBYTES = 12;
    public static final byte XCHACHA20POLY1305_TAG_PUSH = 1;
    public static final byte XCHACHA20POLY1305_TAG_REKEY = 2;
    public static final byte XCHACHA20POLY1305_TAG_MESSAGE = 0;
    public static final byte XCHACHA20POLY1305_TAG_FINAL = 3;
    public static final long MESSAGEBYTES_MAX = 0x800000000L;
    public static final byte TAG_PUSH = 1;
    public static final byte TAG_REKEY = 2;
    public static final byte TAG_MESSAGE = 0;
    public static final byte TAG_FINAL = 3;

    public static class State
    extends Structure {
        public byte[] k = new byte[32];
        public byte[] nonce = new byte[12];
        public byte[] _pad = new byte[8];

        protected List<String> getFieldOrder() {
            return Arrays.asList("k", "nonce", "_pad");
        }

        public static class ByReference
        extends State
        implements Structure.ByReference {
        }
    }

    public static class Checker
    extends BaseChecker {
        public static boolean headerCheck(int headerSize) {
            return headerSize == 24;
        }
    }

    public static interface Lazy {
        public Key cryptoSecretStreamKeygen();

        public State cryptoSecretStreamInitPush(byte[] var1, Key var2) throws SodiumException;

        public String cryptoSecretStreamPush(State var1, String var2, byte var3) throws SodiumException;

        public State cryptoSecretStreamInitPull(byte[] var1, Key var2) throws SodiumException;

        public String cryptoSecretStreamPull(State var1, String var2, byte[] var3) throws SodiumException;

        public void cryptoSecretStreamRekey(State var1);
    }

    public static interface Native {
        public void cryptoSecretStreamKeygen(byte[] var1);

        public boolean cryptoSecretStreamInitPush(State var1, byte[] var2, byte[] var3);

        public boolean cryptoSecretStreamPush(State var1, byte[] var2, long[] var3, byte[] var4, long var5, byte[] var7, long var8, byte var10);

        public boolean cryptoSecretStreamPush(State var1, byte[] var2, long[] var3, byte[] var4, long var5, byte var7);

        public boolean cryptoSecretStreamPush(State var1, byte[] var2, byte[] var3, long var4, byte var6);

        public boolean cryptoSecretStreamInitPull(State var1, byte[] var2, byte[] var3);

        public boolean cryptoSecretStreamPull(State var1, byte[] var2, long[] var3, byte[] var4, byte[] var5, long var6, byte[] var8, long var9);

        public boolean cryptoSecretStreamPull(State var1, byte[] var2, byte[] var3, byte[] var4, long var5);

        public void cryptoSecretStreamRekey(State var1);
    }
}

