/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test.runner;

import com.codingapi.test.annotation.DBType;
import com.codingapi.test.annotation.TestMethod;
import com.codingapi.test.config.TestConfig;
import com.codingapi.test.runner.IMongoRunner;
import com.codingapi.test.runner.IRelationalDbRunner;
import com.codingapi.test.runner.ITestPrepare;
import com.codingapi.test.xml.XmlInfo;
import com.codingapi.test.xml.XmlUtils;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;

public class DefaultTestPrepare
implements ITestPrepare {
    private static final Logger log = LoggerFactory.getLogger(DefaultTestPrepare.class);

    @Override
    public void prepare(TestMethod testMethod, TestContext testContext) throws Exception {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        TestConfig testConfig = (TestConfig)applicationContext.getBean(TestConfig.class);
        String path = testConfig.getOutPath();
        if (testMethod.prepareData().length > 0) {
            for (String xmlFile : testMethod.prepareData()) {
                String xml = FileUtils.readFileToString((File)new File(path + "/" + xmlFile));
                XmlInfo xmlInfo = XmlUtils.parser(xml);
                if (xmlInfo.getDbType().equals((Object)DBType.RELATIONAL)) {
                    try {
                        IRelationalDbRunner relationalDbRunner = (IRelationalDbRunner)applicationContext.getBean(IRelationalDbRunner.class);
                        if (relationalDbRunner != null) {
                            relationalDbRunner.prepare(applicationContext, xmlInfo);
                        }
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        log.warn("no relational prepare runner ");
                    }
                }
                if (!xmlInfo.getDbType().equals((Object)DBType.MONGODB)) continue;
                try {
                    IMongoRunner mongoRunner = (IMongoRunner)applicationContext.getBean(IMongoRunner.class);
                    if (mongoRunner == null) continue;
                    mongoRunner.prepare(applicationContext, xmlInfo);
                }
                catch (NoSuchBeanDefinitionException e) {
                    log.warn("no mongo prepare runner ");
                }
            }
        }
    }
}

