/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client;

import com.codota.service.client.AuthClient;
import com.codota.service.client.CodotaConnectionException;
import com.codota.service.client.CodotaHttpException;
import com.codota.service.client.CrossRefResults;
import com.codota.service.client.SearchResults;
import com.codota.service.client.SearchStats;
import com.codota.service.client.TypeaheadResult;
import com.codota.service.client.requests.DecryptBatchRequest;
import com.codota.service.client.requests.DecryptRequest;
import com.codota.service.client.requests.GetArtifactDependenciesRequest;
import com.codota.service.client.requests.GetArtifactRequest;
import com.codota.service.client.requests.GetDependenciesRequest;
import com.codota.service.client.requests.GetManualDependenciesRequest;
import com.codota.service.client.requests.ListClassesRequest;
import com.codota.service.client.requests.ListFilesRequest;
import com.codota.service.client.requests.PutManualDependenciesRequest;
import com.codota.service.client.requests.SearchCrossRefRequest;
import com.codota.service.client.requests.SearchRequest;
import com.codota.service.client.requests.SearchStatsRequest;
import com.codota.service.client.requests.SearchTaskRequest;
import com.codota.service.client.requests.TextSearchRequest;
import com.codota.service.client.requests.TypeaheadRequest;
import com.codota.service.client.requests.XRefMethodsRequest;
import com.codota.service.client.requests.XRefTypeaheadRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.Artifact;
import com.codota.service.model.Bookmark;
import com.codota.service.model.DependencyInfo;
import com.codota.service.model.TextualMatch;
import com.codota.service.model.XRefMethodItem;
import com.codota.service.model.XRefTypeaheadResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchClient
extends AuthClient {
    private static final String XREF_METHODS_ROUTE = "/api/completions/";
    @Nullable
    private static SearchClient instance;
    private String defaultCodePack;

    public static void clearClient() {
        instance = null;
    }

    public SearchClient(ServiceConnector connector) {
        super(connector);
    }

    @NotNull
    public static SearchClient client(ServiceConnector connector) {
        if (instance == null) {
            instance = new SearchClient(connector);
        }
        return instance;
    }

    public void setDefaultCodePack(String codePack) {
        this.defaultCodePack = codePack;
    }

    public SearchResults search(String query) throws CodotaHttpException, CodotaConnectionException {
        return (SearchResults)new SearchRequest(this.connector, this.token, query).run();
    }

    public SearchResults searchByTask(String query) throws CodotaHttpException, CodotaConnectionException {
        return (SearchResults)new SearchTaskRequest(this.connector, this.token, query).run();
    }

    public List<TypeaheadResult> typeahead(String prefix) throws CodotaHttpException, CodotaConnectionException {
        return (List)new TypeaheadRequest(this.connector, this.token, prefix).run();
    }

    public XRefTypeaheadResult xreftypeahead(String codepack, String prefix) throws CodotaHttpException, CodotaConnectionException {
        return (XRefTypeaheadResult)new XRefTypeaheadRequest(this.connector, prefix, this.makeBasicPropertyMap(codepack), this.token).run();
    }

    public XRefTypeaheadResult xreftypeahead(String prefix) throws CodotaHttpException, CodotaConnectionException {
        return this.xreftypeahead(null, prefix);
    }

    public List<XRefMethodItem> xrefMethodsPerClass(String codepack, String classKey) throws CodotaHttpException, CodotaConnectionException {
        Map<String, String> props = this.makeBasicPropertyMap(codepack);
        props.put("derived", "false");
        try {
            String route = XREF_METHODS_ROUTE + URLEncoder.encode(codepack, "UTF-8") + "/methods/" + URLEncoder.encode(classKey, "UTF-8");
            return (List)new XRefMethodsRequest(this.connector, route, props, this.token).run();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CrossRefResults searchCrossRef(Map<String, String> props) throws CodotaHttpException, CodotaConnectionException {
        return (CrossRefResults)new SearchCrossRefRequest(this.connector, props, this.token).run();
    }

    public List<TextualMatch> textSearch(String term, boolean all) throws CodotaHttpException, CodotaConnectionException {
        return (List)new TextSearchRequest(this.connector, term, this.defaultCodePack, all, this.token).run();
    }

    public DependencyInfo getDependencies(String filepath, String artifactName) throws CodotaHttpException, CodotaConnectionException {
        return (DependencyInfo)new GetDependenciesRequest(this.connector, filepath, artifactName, this.defaultCodePack, this.token).run();
    }

    public List<Map.Entry<String, DependencyInfo>> getArtifactDependencies(String artifactName) throws CodotaHttpException, CodotaConnectionException {
        return (List)new GetArtifactDependenciesRequest(this.connector, artifactName, this.defaultCodePack, this.token).run();
    }

    public Artifact readArtifact(String artifactName) throws CodotaHttpException, CodotaConnectionException {
        return (Artifact)new GetArtifactRequest(this.connector, artifactName, this.defaultCodePack, this.token).run();
    }

    public List<String> allFilesForArtifact(String artifactName) throws CodotaHttpException, CodotaConnectionException {
        return (List)new ListFilesRequest(this.connector, artifactName, this.defaultCodePack, this.token).run();
    }

    public List<String> allClassesForArtifact(String artifactName) throws CodotaHttpException, CodotaConnectionException {
        return (List)new ListClassesRequest(this.connector, artifactName, this.defaultCodePack, this.token).run();
    }

    public SearchStats searchStats(Set<String> queries) throws CodotaHttpException, CodotaConnectionException {
        return (SearchStats)new SearchStatsRequest(this.connector, this.token, queries).run();
    }

    @Nullable
    public Collection<Bookmark> decryptBatch(String decrypt_url, Collection<Bookmark> bookmarks) throws CodotaHttpException {
        return new DecryptBatchRequest(this.connector, decrypt_url, this.token, bookmarks).run();
    }

    @Nullable
    public String decrypt(String decrypt_url, Bookmark bookmark) throws CodotaHttpException {
        return new DecryptRequest(this.connector, decrypt_url, this.token, bookmark).run();
    }

    public List<String> getManualDependencies(String codePack, String artifactName, String filePath) throws CodotaHttpException, CodotaConnectionException {
        GetManualDependenciesRequest request = new GetManualDependenciesRequest(this.connector, artifactName, codePack, filePath, this.token);
        List response = (List)request.run();
        return response;
    }

    public void putManualDependencies(String codePack, String artifactName, String filePath, Set<String> dependenciesFullyQualifiedNames) throws CodotaHttpException, CodotaConnectionException {
        PutManualDependenciesRequest request = new PutManualDependenciesRequest(this.connector, this.token, codePack, artifactName, filePath, dependenciesFullyQualifiedNames);
        String response = (String)request.run();
        if (!"OK".equals(response.trim())) {
            throw new RuntimeException("Error putting manual dependencies: " + response);
        }
    }

    @NotNull
    private Map<String, String> makeBasicPropertyMap(@Nullable String codepack) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (codepack == null) {
            codepack = this.defaultCodePack;
        }
        if (codepack != null) {
            props.put("codePack", codepack);
        }
        return props;
    }
}

