package com.codota.service.client.requests;

import com.codota.service.client.requests.base.PostRequest;
import com.codota.service.client.requests.base.PutRequest;
import com.codota.service.connector.ServiceConnector;
import com.google.gson.*;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Created by shaia on 25/05/2017.
 * This request attaches dependencies to a source file.
 * If the source file already has attached dependencies, they shall be replaced with the newly given ones.
 */
public class PutManualDependenciesRequest extends PutRequest<String> {

    private static final String POST_MANUAL_DEPENDENCIES_ROUTE = "/api/codenav/manualDependencies";

    /**
     * @param connector The connector that sends the request.
     * @param token The security token for connecting to the server.
     * @param codePack The code pack to which the artifcat belongs.
     * @param artifactName The name of the artifcat to which the source file belongs.
     * @param filePath The path of the file to which the dependencies shall be attached.
     * @param dependenciesFullyQualifiedNames The fully qualified names of the dependencies to attach.
     *                                        use '/' instead of '.' between package names.
     */
    public PutManualDependenciesRequest(ServiceConnector connector, String token, String codePack, String artifactName,
                                        String filePath, Set<String> dependenciesFullyQualifiedNames) {
        super(connector, connector.getBase() + POST_MANUAL_DEPENDENCIES_ROUTE, token,
                buildProps(codePack, artifactName, filePath));
        withBodyJsonString("{\"references\":" +  gson.toJson(dependenciesFullyQualifiedNames) + "}");
      }

    private static Map<String, String> buildProps(String codePack, String artifactName, String filepath) {
        Map<String, String> props = new HashMap<String, String>();
        props.put("codePack", codePack);
        props.put("artifactName", artifactName);
        props.put("filepath", filepath);
        return props;
    }

    @Override
    public String parse(String response) {
        return response;
    }


}
