/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests.base;

import com.codota.service.connector.ServiceConnector;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public abstract class Request {
    protected static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    protected final ServiceConnector connector;
    final String route;
    final String token;
    Map<String,String> headerAttributes = new HashMap<String, String>();
    Map<String,String> bodyAttributes = new HashMap<String, String>();
    protected Map<String,String> queryParameters = new HashMap<String, String>();

    public Request(ServiceConnector connector, String route, String token) {
        this.connector = connector;
        this.route = route;
        this.token = token;
    }

    public Request withQueryParams(Map<String,String> queryParams) {
        this.queryParameters = queryParams;
        return this;
    }

    public Request withHeaderAttributes(Map<String,String> headerAttributes) {
        this.headerAttributes = headerAttributes;
        return this;
    }

    public Request withBodyAttributes(Map<String,String> bodyAttributes) {
        this.bodyAttributes = bodyAttributes;
        return this;
    }

    public Request withQueryParameter(String key, String value) {
         queryParameters.put(key,value);
        return this;
    }

    public Request withBodyAttribute(String key, String value) {
       bodyAttributes.put(key,value);
        return this;
    }

    public Request withHeaderAttribute(String key, String value) {
        headerAttributes.put(key,value);
        return this;
    }

    public Map<String, String> getHeaderAttributes() {
        return headerAttributes;
    }

    public Map<String, String> getBodyAttributes() {
        return bodyAttributes;
    }

    public Map<String, String> getQueryParameters() {
        return queryParameters;
    }

    public String getToken() {
        return token;
    }

    public String getRoute() {
        return route;
    }
}
