/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.utils;

import com.codota.service.model.Location;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

/**
 * Created by yahave on 2/27/16.
 * (C) Codota
 */
public class ModelUtils {

    protected static final Gson gson = new GsonBuilder().create();

    public static Location parseLocationString(@NotNull String json) {
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(json);
        return gson.fromJson(root, Location.class);
    }
}
