/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client.requests;

import com.codota.service.client.CodotaHttpException;
import com.codota.service.client.CodotaResponse;
import com.codota.service.client.requests.base.Request;
import com.codota.service.connector.ConnectorSettings;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.Bookmark;
import com.codota.service.model.Location;
import com.codota.service.utils.LogUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecryptBatchRequest
extends Request {
    final Collection<Bookmark> bookmarks;

    public DecryptBatchRequest(ServiceConnector connector, String route, String token, Collection<Bookmark> bookmarks) {
        super(connector, route, token);
        this.bookmarks = bookmarks;
    }

    @Nullable
    public Collection<Bookmark> run() throws CodotaHttpException {
        HashMap<String, String[][]> payload = new HashMap<String, String[][]>();
        HashMap<String[], Bookmark> srcLineTriplets = new HashMap<String[], Bookmark>();
        HashMap<String[], Bookmark> locationTriplets = new HashMap<String[], Bookmark>();
        ArrayList<String[]> allTriplets = new ArrayList<String[]>();
        for (Bookmark b : this.bookmarks) {
            ConnectorSettings.LOG.debug("processing bookmark " + b._id);
            if (b.isEncrypted() && b.sourceLine != null) {
                ConnectorSettings.LOG.debug("collecting non-null sourceLine " + b._id);
                String[] srcLineTriplet = new String[]{b.encryption_key, b.encryption_iv, b.sourceLine};
                srcLineTriplets.put(srcLineTriplet, b);
                allTriplets.add(srcLineTriplet);
                if (!(b.location instanceof String)) continue;
                ConnectorSettings.LOG.debug("collecting bookmark location " + b._id);
                String location = (String)b.location;
                String[] locationTriplet = new String[]{b.encryption_key, b.encryption_iv, location};
                locationTriplets.put(locationTriplet, b);
                allTriplets.add(locationTriplet);
                continue;
            }
            ConnectorSettings.LOG.debug("nothing to decrypt " + b._id);
            b.setDecrypted(true);
        }
        if (allTriplets.isEmpty()) {
            return this.bookmarks;
        }
        String[][] reqData = (String[][])allTriplets.toArray((T[])new String[allTriplets.size()][3]);
        payload.put("reqData", reqData);
        String g = gson.toJson(payload);
        CodotaResponse response = this.connector.postJson(this.getRoute(), g, this.getToken());
        if (response == null) {
            ConnectorSettings.LOG.debug("DecryptBatchRequest got null response, returning original bookmarks");
            return this.bookmarks;
        }
        String[] strings = this.handleDecryptBatchResponse(response);
        for (int i = 0; i < allTriplets.size(); ++i) {
            Object[] triplet = reqData[i];
            String decryptedData = strings[i];
            Bookmark bm = (Bookmark)srcLineTriplets.get(triplet);
            if (bm != null) {
                ConnectorSettings.LOG.debug("DecryptBatchRequest: decrypted info " + bm._id);
                bm.setSourceLine(decryptedData);
                bm.setDecrypted(true);
                continue;
            }
            bm = (Bookmark)locationTriplets.get(triplet);
            if (bm != null) {
                ConnectorSettings.LOG.debug("DecryptBatchRequest: decrypted location " + bm._id);
                JsonParser parser = new JsonParser();
                JsonElement root = parser.parse(decryptedData);
                Location loc = (Location)gson.fromJson(root, Location.class);
                bm.setLocation(loc);
                continue;
            }
            ConnectorSettings.LOG.debug("DecryptBatchRequest: something bad happened with " + Arrays.toString(triplet));
        }
        return this.bookmarks;
    }

    private String[] handleDecryptBatchResponse(@NotNull CodotaResponse response) throws CodotaHttpException {
        if (!response.isOK()) {
            ConnectorSettings.LOG.debug("handleDecryptBatchResponse response code " + response.status);
            ConnectorSettings.LOG.warn("status: " + response.status);
            ConnectorSettings.LOG.warn("content: " + LogUtils.shorten(response.content));
            throw new CodotaHttpException(response.status, response.content);
        }
        String json = response.content;
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(json);
        return (String[])gson.fromJson(root, String[].class);
    }
}

