/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client.requests.base;

import com.codota.service.connector.ServiceConnector;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;

public abstract class Request {
    protected static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    protected final ServiceConnector connector;
    final String route;
    final String token;
    Map<String, String> headerAttributes = new HashMap<String, String>();
    Map<String, String> bodyAttributes = new HashMap<String, String>();
    protected Map<String, String> queryParameters = new HashMap<String, String>();

    public Request(ServiceConnector connector, String route, String token) {
        this.connector = connector;
        this.route = route;
        this.token = token;
    }

    public Request withQueryParams(Map<String, String> queryParams) {
        this.queryParameters = queryParams;
        return this;
    }

    public Request withHeaderAttributes(Map<String, String> headerAttributes) {
        this.headerAttributes = headerAttributes;
        return this;
    }

    public Request withBodyAttributes(Map<String, String> bodyAttributes) {
        this.bodyAttributes = bodyAttributes;
        return this;
    }

    public Request withQueryParameter(String key, String value) {
        this.queryParameters.put(key, value);
        return this;
    }

    public Request withBodyAttribute(String key, String value) {
        this.bodyAttributes.put(key, value);
        return this;
    }

    public Request withHeaderAttribute(String key, String value) {
        this.headerAttributes.put(key, value);
        return this;
    }

    public Map<String, String> getHeaderAttributes() {
        return this.headerAttributes;
    }

    public Map<String, String> getBodyAttributes() {
        return this.bodyAttributes;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public String getToken() {
        return this.token;
    }

    public String getRoute() {
        return this.route;
    }
}

