/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client;

import com.codota.service.model.Bookmark;
import com.codota.service.model.BookmarkCount;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by yahave on 2/23/16.
 * (C) Codota
 */


public class CrossRefResults {
    public static final CrossRefResults EMPTY = new CrossRefResults();

    @SuppressWarnings("CanBeFinal")
    public List<Bookmark> bookmarks;
    public boolean all;
    public BookmarkCount count;

    public CrossRefResults() {
        bookmarks = Collections.emptyList();
    }

    @SuppressWarnings("StringBufferReplaceableByString")
    @NotNull
    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("CrossRefResults{");
        sb.append("bookmarks=").append(bookmarks);
        sb.append(", all=").append(all);
        sb.append(", count=").append(count);
        sb.append('}');
        return sb.toString();
    }


    public boolean isEmpty() {
        return bookmarks == null || bookmarks.isEmpty();
    }

    public void addAll(@NotNull CrossRefResults other) {
        addAll(other,null);
    }

    public void addAll(@NotNull CrossRefResults other, String signature) {
        //TODO: this does not update all the BookmarkCount fields, and it should
        if (bookmarks == Collections.EMPTY_LIST) {
            bookmarks = new ArrayList<Bookmark>();
        }
        for (Bookmark b : other.bookmarks) {
            if (signature != null) b.setSignature(signature);
            bookmarks.add(b);
        }
        //bookmarks.addAll(other.bookmarks);
        if (count != null && other.count != null) {
            count.count += other.count.count;
        }
    }



}
