package com.codota.service.client.requests;

import com.codota.service.client.ClientFeatures;
import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

/**
 * Created by yahave on 21/12/2016.
 */
public class ClientFeaturesRequest extends GetRequest<ClientFeatures> {
    private static final String CLIENT_FEATURES_PREFIX = "/api/client/";
    private static final String CLIENT_FEATURES_SUFFIX = "/features";

    public ClientFeaturesRequest(ServiceConnector connector, String uuid) {
        super(connector, connector.getBase() + CLIENT_FEATURES_PREFIX + uuid + CLIENT_FEATURES_SUFFIX, null, null);
    }

    @Override
    public ClientFeatures parse(@NotNull String json) {
        ClientFeatures features = ClientFeatures.UNKNOWN;
        try {
            JsonParser parser = new JsonParser();
            JsonElement root = parser.parse(json);
            features = gson.fromJson(root, ClientFeatures.class);
        } catch (IllegalStateException e) {
            System.err.println("json" + json);
            e.printStackTrace();
        } catch (com.google.gson.JsonSyntaxException e) {
            System.err.println("json" + json);
            e.printStackTrace();
        }
        return features;
    }

}
