/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.DependencyInfo;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public class GetDependenciesRequest extends GetRequest<DependencyInfo> {

    private static final String FIND_DEP_ROUTE = "/api/codenav/dependencies";

    public GetDependenciesRequest(ServiceConnector connector, String filepath, String artifactName, String codePack, String token) {
        super(connector, connector.getBase() + FIND_DEP_ROUTE, null, buildProps(filepath, artifactName, codePack), token);

    }


    private static Map<String, String> buildProps(String filepath, String artifactName, String codePack) {
        Map<String, String> props = new HashMap<String, String>();
        props.put("filepath", filepath);
        props.put("artifactName", artifactName);
        props.put("codePack", codePack);
        return props;
    }


    @NotNull
    public DependencyInfo parse(@NotNull String response) {
        DependencyInfo result = null;
        try {
            result = gson.fromJson(response, DependencyInfo.class);
        } catch (IllegalStateException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        } catch (com.google.gson.JsonSyntaxException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }

        return result;
    }

}
