/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.TextualMatch;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class TextSearchRequest extends GetRequest<List<TextualMatch>> {

    private static final String TEXT_SEARCH_ROUTE = "/api/search/source/";

    public TextSearchRequest(ServiceConnector connector, String term, String codePack, boolean all, String token) {
        super(connector, connector.getBase() + TEXT_SEARCH_ROUTE, term, buildProps(codePack, all), token);

    }


    private static Map<String, String> buildProps(String codePack, boolean all) {
        Map<String, String> props = new HashMap<String, String>();
        props.put("codePack", codePack);
        if (all) {
            props.put("all", "true");
        }
        return props;
    }


    @NotNull
    public List<TextualMatch> parse(@NotNull String response) {
        TextualMatch[] result = {};
        try {
            JsonParser parser = new JsonParser();
            JsonElement root = parser.parse(response);
            result = gson.fromJson(root.getAsJsonObject().getAsJsonArray("files"), TextualMatch[].class);
        } catch (IllegalStateException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        } catch (com.google.gson.JsonSyntaxException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }

        return Arrays.asList(result);
    }

}
