/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests.base;

import com.codota.service.client.CodotaConnectionException;
import com.codota.service.client.CodotaHttpException;
import com.codota.service.client.CodotaResponse;
import com.codota.service.client.requests.base.Request;
import com.codota.service.connector.ServiceConnector;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public abstract class GetRequest<T> extends Request {

    String query;

    public GetRequest(ServiceConnector connector, String route) {
        super(connector,route,null);
    }

    public GetRequest(ServiceConnector connector, String route, @Nullable  String token, @Nullable String query) {
        super(connector,route,token);
        this.query = query;
    }

    public GetRequest(ServiceConnector connector, String route, @Nullable String query, @Nullable Map<String, String> props, @Nullable String token) {
        super(connector, route, token);
        this.query = query;
        this.queryParameters = props;
    }

    public T run() throws CodotaConnectionException, CodotaHttpException {
        T result;
        CodotaResponse response = connector.get(this);
        if (response == null) {
            throw new CodotaConnectionException();
        }
        if (response.isOK()) {
            result = parse(response.content);
        } else {
            throw new CodotaHttpException(response.status, response.content);
        }
        return result;
    }
    
    public abstract T parse(String response);

    public String getQuery() {
        return query;
    }
}
