/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.connector;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Created by yahave on 12/25/14.
 * (C) Codota
 */
@SuppressWarnings("UnusedDeclaration")
public class ConnectorSettings {

    public static final String CODOTA_LOCALHOST = "CodotaLocalhost";
    public static final String USER_AGENT = "Codota IDE";
    public static CodotaLogger LOG = new NullLogger();

    @SuppressWarnings("UnusedDeclaration")
    public enum Host {
        PRD("prd", "https://www.codota.com"),
        GATEWAY("gateway", "https://gateway.codota.com"),
        STAGING("staging", "http://staging.codota.com"),
        LOCAL("local", "http://localhost:5000"),

        @Deprecated
        EXPERIMENTAL("experimental", "https://codota-dependency-api.herokuapp.com");

        public static final Host DEFAULT_HOST = Host.PRD;

        private final String text;
        private final String connectionString;

        Host(String name, String conn) {
            this.text = name;
            this.connectionString = conn;
        }
    }

    // init host to default host
    @Nullable
    public static String host = Host.DEFAULT_HOST.connectionString;

    private static String clientVersion = "0.1.3-sdk";

    public static boolean isLocal() {
        return host.equals(Host.LOCAL.connectionString);
    }

    public static void setHost(@NotNull Host h) {
        ConnectorSettings.host = h.connectionString;
    }

    public static void setHost(String host) {
        ConnectorSettings.host = host;
    }

    public static String getDefaultBase() {
        return host;
    }

    public static void setClientVersion(String version) {
        clientVersion = version;
    }

    public static String getClientVersion() {
        return clientVersion;
    }

    public static void setLogger(CodotaLogger logger) {
        LOG = logger;
    }

}
