/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * Created by yahave on 12/14/15.
 * (C) Codota
 */
@SuppressWarnings("UnusedDeclaration")
public class AccountInfo {
    public String _id;
    public String displayName;
    List<String> excludePacks;
    String logoLarge;
    String logoSmall;
    public String name;
    List<String> packs;
    public boolean hasTrackingAlias;
    public boolean justLoggedIn;
    public String decryptionUrl;

    @NotNull
    public String toString() {
        return name + ","  + displayName + ":" + packs;
    }

    @Nullable
    public String firstPack() {
        if (packs != null && packs.isEmpty())
            return packs.get(0);
        else
            return null;
    }
}
