/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

/**
 * Created by yahave on 2/23/16.
 * (C) Codota
 */

import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * {
 "_id": "xxx",
 "artifactName": "com.squareup.okhttp.mockwebserver",
 "codePack": "xxxx",
 "encrypted": false,
 "filepath": "com/squareup/okhttp/mockwebserver/QueueDispatcher.java",
 "jarFile": "mockwebserver-2.6.0-SNAPSHOT-sources.jar",
 "location": {
 "length": 13,
 "col": 18,
 "line": 27,
 "unitName": null
 },
 "origin": {
 "rawSourceId": "xxx",
 "compilationResultId": "xxx"
 },
 "refType": "TYPE-OF-VAR",
 "resourceFullyQualifiedName": "com/squareup/okhttp/mockwebserver/QueueDispatcher",
 "sourceLine": "  protected final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<>();",
 "type": "reference",
 "url": "http://www.codota.com/xref/#/nav/bookmark?id=xxx",
 "refTypeDisplayName": "TYPE"
 }
 *
 */
public class Bookmark {
    public String _id;
    public String artifactName;
    public String codePack;
    private boolean encrypted;
    public boolean decrypted;
    public String filepath;
    public String jarFile;
    public Object location;
    public BookmarkOrigin origin;
    public String refType;
    public String resourceFullyQualifiedName;
    public String sourceLine;
    public String type;
    public String url;
    public String refTypeDisplayName;
    public String encryption_key;
    public String encryption_iv;
    public String icon;

    private Location parsed_location;
    private boolean sourceLineOverwritten;
    private String locationFromString;
    private String signature;

    public String getSourceLine() {
        if (sourceLine == null)
            return "";
        else if (encrypted && !sourceLineOverwritten)
            return "encrypted";
        else
            return sourceLine;
    }


    public Location getLocation() {
        if (!encrypted && parsed_location == null) {
            if (location instanceof Map) {
                Map mloc = (Map)location;
                parsed_location = new Location(mloc);
            }

        }
        return parsed_location;
    }

    @NotNull
    public BookmarkType getType() {
        return BookmarkType.getType(refTypeDisplayName);
    }

    @SuppressWarnings("StringBufferReplaceableByString")
    @NotNull
    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("Bookmark{");
        sb.append("_id='").append(_id).append('\'');
        sb.append(", artifactName='").append(artifactName).append('\'');
        sb.append(", codePack='").append(codePack).append('\'');
        sb.append(", encrypted=").append(encrypted);
        sb.append(", decrypted=").append(decrypted);
        sb.append(", filepath='").append(filepath).append('\'');
        sb.append(", jarFile='").append(jarFile).append('\'');
        sb.append(", location=").append(location);
        sb.append(", parsed_location=").append(parsed_location);
        sb.append(", origin=").append(origin);
        sb.append(", refType='").append(refType).append('\'');
        sb.append(", resourceFullyQualifiedName='").append(resourceFullyQualifiedName).append('\'');
        sb.append(", sourceLine='").append(sourceLine).append('\'');
        sb.append(", type='").append(type).append('\'');
        sb.append(", url='").append(url).append('\'');
        sb.append(", refTypeDisplayName='").append(refTypeDisplayName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public void setSourceLine(String sourceLine) {
        this.sourceLine = sourceLine;
        sourceLineOverwritten = true;
    }

    public void setLocationFromString(String locationFromString) {
        this.locationFromString = locationFromString;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.parsed_location = location;
    }

    public boolean isPresentable() {
        Location l = getLocation();
        // when encrypted, and encryption faile, the location we get here will be null
        if (isEncrypted() && !isDecrypted()) {
            return sourceLine != null && !sourceLine.isEmpty();
        }
        // in all other cases, employ the full check
        return (l != null && l.line >=0 && sourceLine != null && !sourceLine.isEmpty());
    }

    /**
     * A hack that is used to update the bookmark with signature information
     * @param signature
     */
    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return signature;
    }

    public boolean isDecrypted() {
        return decrypted;
    }

    public boolean isEncrypted() {
        return encrypted;
    }

    public void setDecrypted(boolean decrypted) {
        this.decrypted = decrypted;
    }
}
