/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

/**
 * Created by yahave on 2/23/16.
 * (C) Codota
 */
public enum BookmarkType {
    CALL("CALL","call"),
    TYPE_OF_VAR("TYPE-OF-VAR","variable"),
    TYPE("TYPE","type"),
    GENERAL("GENERAL","general"),
    TYPE_PARAM("TYPE-PARAM","parameter"),
    FIELD_ACCESS("FIELD-ACCESS","field access"),
    VAR_REF("VAR-REF", "variable reference"),
    RETURN_TYPE("RETURN-TYPE", "return type"),
    EXTEND("EXTEND","extend"),
    IMPLEMENT("IMPLEMENT","implement"),
    INSTANTIATE("INSTANTIATE","instantiate"),
    IMPORT("IMPORT","import");

    final String name;
    final String text;

    final static Map<String,BookmarkType> namesToBookmarkTypes = new HashMap<String,BookmarkType>();

    static {
        for (BookmarkType bt : BookmarkType.values()) {
            namesToBookmarkTypes.put(bt.getName(), bt);
        }
    }

    BookmarkType(@NotNull String name,String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return name;
    }

    public String getText() { return text; }

    @NotNull
    public static BookmarkType getType(String name) {
        if (name == null) return GENERAL;
        BookmarkType result = namesToBookmarkTypes.get(name);
        return result != null ? result : GENERAL;
    }

}
