/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client;

import com.codota.service.model.Bookmark;
import com.codota.service.model.BookmarkCount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CrossRefResults {
    public static final CrossRefResults EMPTY = new CrossRefResults();
    public List<Bookmark> bookmarks = Collections.emptyList();
    public boolean all;
    public BookmarkCount count;

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("CrossRefResults{");
        sb.append("bookmarks=").append(this.bookmarks);
        sb.append(", all=").append(this.all);
        sb.append(", count=").append(this.count);
        sb.append('}');
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.bookmarks == null || this.bookmarks.isEmpty();
    }

    public void addAll(@NotNull CrossRefResults other) {
        this.addAll(other, null);
    }

    public void addAll(@NotNull CrossRefResults other, String signature) {
        if (this.bookmarks == Collections.EMPTY_LIST) {
            this.bookmarks = new ArrayList<Bookmark>();
        }
        for (Bookmark b : other.bookmarks) {
            if (signature != null) {
                b.setSignature(signature);
            }
            this.bookmarks.add(b);
        }
        if (this.count != null && other.count != null) {
            this.count.count += other.count.count;
        }
    }
}

