/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.DependencyInfo;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GetArtifactDependenciesRequest
extends GetRequest<Map<String, DependencyInfo>> {
    private static final String FIND_DEP_ROUTE = "/api/codenav/artifact-dependencies";

    public GetArtifactDependenciesRequest(ServiceConnector connector, String artifactName, String codePack, String token) {
        super(connector, connector.getBase() + FIND_DEP_ROUTE, null, GetArtifactDependenciesRequest.buildProps(artifactName, codePack), token);
    }

    private static Map<String, String> buildProps(String artifactName, String codePack) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("artifactName", artifactName);
        props.put("codePack", codePack);
        return props;
    }

    @Override
    @NotNull
    public Map<String, DependencyInfo> parse(@NotNull String response) {
        try {
            List<Object> fileDependencies = Arrays.asList((Object[])gson.fromJson(response, FileDependency[].class));
            HashMap<String, DependencyInfo> result = new HashMap<String, DependencyInfo>();
            fileDependencies.forEach(dep -> result.put(dep.filepath, dep.dependencies));
            return result;
        }
        catch (IllegalStateException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }
        return null;
    }

    private static class FileDependency {
        String filepath;
        DependencyInfo dependencies;

        private FileDependency() {
        }
    }
}

