/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.model;

import com.codota.service.model.BookmarkOrigin;
import com.codota.service.model.BookmarkType;
import com.codota.service.model.Location;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Bookmark {
    public String _id;
    public String artifactName;
    public String codePack;
    private boolean encrypted;
    public boolean decrypted;
    public String filepath;
    public String jarFile;
    public Object location;
    public BookmarkOrigin origin;
    public String refType;
    public String resourceFullyQualifiedName;
    public String sourceLine;
    public String type;
    public String url;
    public String refTypeDisplayName;
    public String encryption_key;
    public String encryption_iv;
    public String icon;
    private Location parsed_location;
    private boolean sourceLineOverwritten;
    private String locationFromString;
    private String signature;

    public String getSourceLine() {
        if (this.sourceLine == null) {
            return "";
        }
        if (this.encrypted && !this.sourceLineOverwritten) {
            return "encrypted";
        }
        return this.sourceLine;
    }

    public Location getLocation() {
        if (!this.encrypted && this.parsed_location == null && this.location instanceof Map) {
            Map mloc = (Map)this.location;
            this.parsed_location = new Location(mloc);
        }
        return this.parsed_location;
    }

    @NotNull
    public BookmarkType getType() {
        return BookmarkType.getType(this.refTypeDisplayName);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("Bookmark{");
        sb.append("_id='").append(this._id).append('\'');
        sb.append(", artifactName='").append(this.artifactName).append('\'');
        sb.append(", codePack='").append(this.codePack).append('\'');
        sb.append(", encrypted=").append(this.encrypted);
        sb.append(", decrypted=").append(this.decrypted);
        sb.append(", filepath='").append(this.filepath).append('\'');
        sb.append(", jarFile='").append(this.jarFile).append('\'');
        sb.append(", location=").append(this.location);
        sb.append(", parsed_location=").append(this.parsed_location);
        sb.append(", origin=").append(this.origin);
        sb.append(", refType='").append(this.refType).append('\'');
        sb.append(", resourceFullyQualifiedName='").append(this.resourceFullyQualifiedName).append('\'');
        sb.append(", sourceLine='").append(this.sourceLine).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", url='").append(this.url).append('\'');
        sb.append(", refTypeDisplayName='").append(this.refTypeDisplayName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public void setSourceLine(String sourceLine) {
        this.sourceLine = sourceLine;
        this.sourceLineOverwritten = true;
    }

    public void setLocationFromString(String locationFromString) {
        this.locationFromString = locationFromString;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.parsed_location = location;
    }

    public boolean isPresentable() {
        Location l = this.getLocation();
        if (this.isEncrypted() && !this.isDecrypted()) {
            return this.sourceLine != null && !this.sourceLine.isEmpty();
        }
        return l != null && l.line >= 0 && this.sourceLine != null && !this.sourceLine.isEmpty();
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isDecrypted() {
        return this.decrypted;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setDecrypted(boolean decrypted) {
        this.decrypted = decrypted;
    }
}

