/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.model;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum BookmarkType {
    CALL("CALL", "call"),
    TYPE_OF_VAR("TYPE-OF-VAR", "variable"),
    TYPE("TYPE", "type"),
    GENERAL("GENERAL", "general"),
    TYPE_PARAM("TYPE-PARAM", "parameter"),
    FIELD_ACCESS("FIELD-ACCESS", "field access"),
    VAR_REF("VAR-REF", "variable reference"),
    RETURN_TYPE("RETURN-TYPE", "return type"),
    EXTEND("EXTEND", "extend"),
    IMPLEMENT("IMPLEMENT", "implement"),
    INSTANTIATE("INSTANTIATE", "instantiate"),
    IMPORT("IMPORT", "import");

    final String name;
    final String text;
    static final Map<String, BookmarkType> namesToBookmarkTypes;

    private BookmarkType(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    @NotNull
    public static BookmarkType getType(String name) {
        if (name == null) {
            return GENERAL;
        }
        BookmarkType result = namesToBookmarkTypes.get(name);
        return result != null ? result : GENERAL;
    }

    static {
        namesToBookmarkTypes = new HashMap<String, BookmarkType>();
        for (BookmarkType bt : BookmarkType.values()) {
            namesToBookmarkTypes.put(bt.getName(), bt);
        }
    }
}

