/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.codota.service.model.Code;
import com.codota.service.model.RelatedRef;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

@SuppressWarnings("UnusedDeclaration")
public class LiveCodeClient {

	private static LiveCodeClient instance;
	private static final Gson gson = new GsonBuilder().create();

	public static LiveCodeClient client() {
		if (instance == null) {
			instance = new LiveCodeClient();
		}
		return instance;
	}

	@NotNull
	public List<RelatedRef> process(Code code) throws IOException {

		List<RelatedRef> results = Collections.emptyList();

		int httpResult;
		String jsonCode = gson.toJson(code);
		String uri = "http://localhost:5000/api/livecode?ver=1.2.0";

		URL url = new URL(uri);
		HttpURLConnection connection = (HttpURLConnection) url.openConnection();
		connection.setDoOutput(true);
		connection.setDoInput(true);
		connection.setRequestMethod("POST");

		connection.setRequestProperty("Content-Type", "application/json");
		connection.setRequestProperty("Accept", "application/json");

		OutputStreamWriter wr = new OutputStreamWriter(
				connection.getOutputStream());
		wr.write(jsonCode);
		wr.flush();

		connection.getInputStream();

		StringBuilder sb = new StringBuilder();

		httpResult = connection.getResponseCode();

		if (httpResult == HttpURLConnection.HTTP_OK) {

			BufferedReader br = new BufferedReader(new InputStreamReader(
					connection.getInputStream(), "utf-8"));

			String line;

			while ((line = br.readLine()) != null) {
				sb.append(line).append("\n");
			}

			br.close();

			String json = sb.toString();

			results = parseJson(json);

		} else {
			System.err.println(connection.getResponseMessage());
		}

		connection.disconnect();

		return results;

	}

	@NotNull
	private List<RelatedRef> parseJson(@NotNull String json) {
		List<RelatedRef> result = new ArrayList<RelatedRef>();
		JsonElement jelement = new JsonParser().parse(json);
		JsonObject jobject = jelement.getAsJsonObject();
		JsonArray jarray = jobject.getAsJsonArray("tuts");
		if (jarray == null)
			return result;
		for (JsonElement jo : jarray) {
			JsonObject j = (JsonObject) jo;
			try {
				RelatedRef rr = new Gson().fromJson(j, RelatedRef.class);
				result.add(rr);
			} catch (Exception e) {
				e.printStackTrace();
				// print and swallow
			}
		}
		return result;

	}

}