/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client;

import com.codota.service.model.Scenario;
import com.codota.service.model.Snippet;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

@SuppressWarnings("UnusedDeclaration")
public class SearchResults {
	public static final SearchResults EMPTY = new SearchResults();
	
	@NotNull
	public final List<Scenario> scenarios;
	@NotNull
	public final List<Snippet> userSnippets;
	
	public SearchResults() {
		scenarios = Collections.emptyList();
		userSnippets = Collections.emptyList();
	}
	
	@NotNull
	public String toString() {
		StringBuilder sb = new StringBuilder();
		for (Scenario s : scenarios) {
			sb.append(s.toString());
		}
		for (Snippet s : userSnippets) {
			sb.append(s.toString());
		}
		return sb.toString();
	}

	public boolean isEmpty() {
		return scenarios.isEmpty() && userSnippets.isEmpty();
	}

}
