package com.codota.service.client.requests;

import com.codota.service.client.CodotaConnectionException;
import com.codota.service.client.CodotaHttpException;
import com.codota.service.client.CodotaResponse;
import com.codota.service.client.requests.base.Request;
import com.codota.service.connector.ServiceConnector;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public abstract class NakedPostRequest<T> extends Request {
    String jsonString;

    public NakedPostRequest(ServiceConnector connector, String route, String token) {
        super(connector, route, token);
    }

    public NakedPostRequest<T> withJsonString(String json) {
        this.jsonString = json;
        return this;
    }

    public T run() throws CodotaConnectionException, CodotaHttpException {
        T result;
        CodotaResponse response = (getBodyAttributes() != null) ?
                connector.post(getRoute(),getBodyAttributes(),getToken())
                : connector.postJson(getRoute(), jsonString, getToken());
        if (response == null) {
            throw new CodotaConnectionException();
        }
        if (response.isOK()) {
            result = parse(response.content);
        } else {
            throw new CodotaHttpException(response.status, response.content);
        }
        return result;
    }

    public abstract T parse(String response);

}
