/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests;

import com.codota.service.client.SearchStats;
import com.codota.service.client.requests.base.PostRequest;
import com.codota.service.connector.ServiceConnector;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public class SearchStatsRequest extends PostRequest<SearchStats> {
    private static final String SEARCH_STATS_ROUTE = "/api/search/stats";

    public SearchStatsRequest(ServiceConnector connector, String token, Set<String> queries) {
        super(connector, connector.getBase() + SEARCH_STATS_ROUTE, token, gson.toJson(queries));
    }

    @NotNull
    @Override
    public SearchStats parse(String response) {
        SearchStats.StatsPair[] arr = gson.fromJson(response, SearchStats.StatsPair[].class);
        return new SearchStats(arr);
    }
}
