/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests;

import com.codota.service.client.TypeaheadResult;
import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public class TypeaheadRequest extends GetRequest<List<TypeaheadResult>> {

    private static final String TYPEAHEAD_ROUTE = "/api/search/typeahead/";

    public TypeaheadRequest(ServiceConnector connector, String token, String prefix) {
        super(connector, connector.getBase() + TYPEAHEAD_ROUTE,token, prefix);
    }

    @NotNull
    @Override
    public List<TypeaheadResult> parse(@NotNull String response) {
        List<TypeaheadResult> results = new ArrayList<TypeaheadResult>();
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(response).getAsJsonArray();
        for (JsonElement o : array) {
            String text = gson.fromJson(o, String.class);
            String splitted[] = text.split(":");
            TypeaheadResult item;
            if (splitted.length > 1) {
                item = new TypeaheadResult(splitted[1], splitted[0]);
            } else {
                item = new TypeaheadResult(splitted[0]);
            }
            results.add(item);
        }
        return results;
    }
}
