/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.XRefTypeaheadResult;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public class XRefTypeaheadRequest extends GetRequest<XRefTypeaheadResult> {
    private static final String XREF_TYPEAHEAD_ROUTE = "/api/search/xrefTypeahead/";

    public XRefTypeaheadRequest(ServiceConnector connector, String query, Map<String, String> props, String token) {
        super(connector, connector.getBase() +  XREF_TYPEAHEAD_ROUTE, query, props, token);
    }

    @Override
    public XRefTypeaheadResult parse(@NotNull String response) {
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(response);
        return gson.fromJson(root, XRefTypeaheadResult.class);
    }
}
