/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

import java.util.Collection;

/**
 * Created by WEISS on 24/07/2016.
 */
public class Artifact {

    private String artifactName;
    private String codePack;
    private Collection<DeveloperInfo> developers;
    private ProjectInfo project;


    public ProjectInfo getProject() {
        return project;
    }

    public String getArtifactName() {
        return artifactName;
    }

    public String getCodePack() {
        return codePack;
    }

    public Collection<DeveloperInfo> getDevelopers() {
        return developers;
    }

    public static class ProjectInfo {
        private String groupId;
        private String artifactId;
        private String version;

        public String getGroupId() {
            return groupId;
        }

        public String getArtifactId() {
            return artifactId;
        }

        public String getVersion() {
            return version;
        }
    }

    public static class DeveloperInfo {
        private String name;
        private String email;
        private Collection<String> roles;

        public String getName() {
            return name;
        }

        public String getEmail() {
            return email;
        }

        public Collection<String> getRoles() {
            return roles;
        }
    }
}
