/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

import org.jetbrains.annotations.NotNull;

import java.util.Comparator;
import java.util.List;

@SuppressWarnings("UnusedDeclaration")
public class RelatedRef {
	
	private static final boolean DEBUG = true;
	
	public RelatedInfo info;
	public String source;
	public String groupKey;
	public float grade;
	public List<Witness> witness;

	@NotNull
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(info);
		if (DEBUG) {
			sb.append("\n");
			sb.append("grade:").append(grade).append(" ");
			for (Witness w : witness) {
				sb.append(w);
				sb.append("\n");
			}
		}
		return sb.toString();

	}

	@NotNull
	public static Comparator<RelatedRef> comparator = new Comparator<RelatedRef>() {
		public int compare(@NotNull RelatedRef rr1, @NotNull RelatedRef rr2) {
			return rr1.grade < rr2.grade ? -1 : rr1.grade > rr2.grade ? 1 : 0;
		}
	};

}
