/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

@SuppressWarnings("UnusedDeclaration")
public class Snippet implements CodeFragment {
	protected String id;
	protected String scenarioId;
	protected String scenarioTag;
	protected String url;
	protected String title;
	protected String code;
	protected String cleanCode;
	protected String cleanSummary;
	protected List<Tag> tags;
	protected String savedTime;
	protected String ownerAvatarUrl;
	protected List<Annotation> annotations;

	@NotNull
	@Override
	public List<Annotation> annotations() {
		return (annotations != null ? annotations : Collections.<Annotation>emptyList());
	}

	@Override
	public String code() {
		return cleanCode;
	}

	@Override
	public String codeSummary() {
		return cleanSummary;
	}

	@Override
	public String copySummary() {
		return code;
	}

	@Override
	public String id() {
		return id;
	}

	@Override
	public String originUrl() {
		return url;
	}


	@Override
	public String url() {
		return url;
	}

	@Override
	public String urlTitle() {
		return title;
	}
}
