/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client;

import com.codota.service.model.Code;
import com.codota.service.model.RelatedRef;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LiveCodeClient {
    private static LiveCodeClient instance;
    private static final Gson gson;

    public static LiveCodeClient client() {
        if (instance == null) {
            instance = new LiveCodeClient();
        }
        return instance;
    }

    @NotNull
    public List<RelatedRef> process(Code code) throws IOException {
        List<RelatedRef> results = Collections.emptyList();
        String jsonCode = gson.toJson((Object)code);
        String uri = "http://localhost:5000/api/livecode?ver=1.2.0";
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
        wr.write(jsonCode);
        wr.flush();
        connection.getInputStream();
        StringBuilder sb = new StringBuilder();
        int httpResult = connection.getResponseCode();
        if (httpResult == 200) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            String json = sb.toString();
            results = this.parseJson(json);
        } else {
            System.err.println(connection.getResponseMessage());
        }
        connection.disconnect();
        return results;
    }

    @NotNull
    private List<RelatedRef> parseJson(@NotNull String json) {
        ArrayList<RelatedRef> result = new ArrayList<RelatedRef>();
        JsonElement jelement = new JsonParser().parse(json);
        JsonObject jobject = jelement.getAsJsonObject();
        JsonArray jarray = jobject.getAsJsonArray("tuts");
        if (jarray == null) {
            return result;
        }
        for (JsonElement jo : jarray) {
            JsonObject j = (JsonObject)jo;
            try {
                RelatedRef rr = (RelatedRef)new Gson().fromJson((JsonElement)j, RelatedRef.class);
                result.add(rr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    static {
        gson = new GsonBuilder().create();
    }
}

