/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.connector;

import com.codota.service.connector.CodotaLogger;
import com.codota.service.connector.NullLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectorSettings {
    public static final String CODOTA_LOCALHOST = "CodotaLocalhost";
    public static final String USER_AGENT = "Codota IDE";
    public static CodotaLogger LOG = new NullLogger();
    @Nullable
    public static String host = Host.access$000(Host.DEFAULT_HOST);
    private static String clientVersion = "0.1.3-sdk";

    public static boolean isLocal() {
        return host.equals(Host.LOCAL.connectionString);
    }

    public static void setHost(@NotNull Host h) {
        host = h.connectionString;
    }

    public static void setHost(String host) {
        ConnectorSettings.host = host;
    }

    public static String getDefaultBase() {
        return host;
    }

    public static void setClientVersion(String version) {
        clientVersion = version;
    }

    public static String getClientVersion() {
        return clientVersion;
    }

    public static void setLogger(CodotaLogger logger) {
        LOG = logger;
    }

    public static enum Host {
        PRD("prd", "https://www.codota.com"),
        GATEWAY("gateway", "https://gateway.codota.com"),
        STAGING("staging", "http://staging.codota.com"),
        LOCAL("local", "http://localhost:5000"),
        EXPERIMENTAL("experimental", "https://codota-dependency-api.herokuapp.com");

        public static final Host DEFAULT_HOST;
        private final String text;
        private final String connectionString;

        private Host(String name, String conn) {
            this.text = name;
            this.connectionString = conn;
        }

        static {
            DEFAULT_HOST = PRD;
        }
    }
}

