/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client;

import com.codota.service.client.requests.BoxRequest;
import com.codota.service.client.requests.SaveToBoxRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.Snippet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("UnusedDeclaration")
public class BoxClient extends AuthClient {

    private static final Gson gson = new GsonBuilder().create();
    private static BoxClient instance;

    public BoxClient(ServiceConnector connector) {
        super(connector);
    }

    public static BoxClient client(ServiceConnector connector) {
        if (instance == null) {
            instance = new BoxClient(connector);
        }
        return instance;
    }

    public List<Snippet> getAllSnippets() throws IOException,
            CodotaHttpException, CodotaConnectionException {
        return new BoxRequest(connector, token).run();
    }


    public String saveToBox(String title, String code, @SuppressWarnings("SameParameterValue") String description, List<String> tags) throws IOException,
            CodotaHttpException, CodotaConnectionException {

        Map<String, String> attribs = new HashMap<String, String>();
        attribs.put("title", title);
        attribs.put("code", code);

        SaveToBoxRequest boxRequest = (SaveToBoxRequest) new SaveToBoxRequest(connector, token).withBodyAttributes(attribs);
        return boxRequest.run();
    }
}
