/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("UnusedDeclaration")
public class TimeTracker implements ITimeTracker {
	private long zero, connected, gotresp;

	private static TimeTracker instance; 
	
	public static TimeTracker instance() {
		if (instance == null) {
			instance = new TimeTracker();
		}
		return instance;
	}
	
	public void init(@NotNull Class serviceConnectorClass) {
		String kind = serviceConnectorClass.toString();
		zero = System.nanoTime();
		System.out.println("--->using " + kind);

	}

	public void connected() {

		connected = System.nanoTime();
		System.out.println("============[connected]=============="
				+ (connected - zero) / 1000000);

	}

	public void gotResponse() {
		gotresp = System.nanoTime();
		System.out.println("============[got response]=============="
				+ (gotresp - connected) / 1000000);
	}

	public void finished() {
		long finished = System.nanoTime();
		System.out.println("============[finished]=============="
				+ (finished - gotresp) / 1000000);
	}

}
